# Domínios do Sistema — Gestor Editorial

Esta pasta organiza os **domínios de negócio** do sistema, separando as responsabilidades e facilitando a comunicação entre frontend e backend.

## 🎯 Objetivo

Organizar as ideias e conceitos do sistema de forma clara, permitindo:
- Alinhamento entre equipes (frontend/backend)
- Evolução planejada de funcionalidades
- Documentação de regras de negócio
- Mapeamento de responsabilidades

## 📂 Estrutura de Domínios

### 1. **Editorial** (`editorial.md`)
Domínio central do sistema. Gerencia o conteúdo editorial do podcast:
- Episódios
- Convidados
- Temas
- Relacionamentos entre entidades editoriais

### 2. **Operacional** (`operacional.md`)
Fluxo de execução e produção:
- Tarefas editoriais
- Assets de produção
- Checklist operacional
- Workflow de status

### 3. **Governança** (`governanca.md`)
Controle de acesso e rastreabilidade:
- Usuários e perfis
- Permissões e autorização
- Logs e auditoria
- Políticas de acesso

### 4. **Inteligência** (`inteligencia.md`)
Insights e análises editoriais:
- Métricas de performance
- Relatórios editoriais
- Análises de conteúdo
- Previsibilidade de publicação

### 5. **Calendário** (`calendario.md`)
Visão temporal e planejamento:
- Agendamento de episódios
- Ritmo editorial
- Previsibilidade de publicação
- Eventos e marcos

### 6. **Relacionamento** (`relacionamento.md`)
Gestão de rede e ecossistema:
- Organizações
- Follow-ups
- Histórico de convidados
- Conexões e desdobramentos

### 7. **Curadoria** (`curadoria.md`)
Pipeline de curadoria e relacionamento editorial:
- Prospects (pessoas e empresas)
- Pipeline de status (to_review → approved → confirmed)
- Critérios de curadoria (score, diversidade)
- Conversão em convidados

## 🔄 Como Usar

1. **Para desenvolvedores**: Consulte os domínios relevantes antes de implementar features
2. **Para planejamento**: Use os domínios para mapear novas funcionalidades
3. **Para documentação**: Atualize os arquivos conforme o sistema evolui

## 📝 Convenções

- Cada domínio deve descrever:
  - **Responsabilidades**: O que o domínio faz
  - **Entidades**: Quais modelos/entidades pertencem a ele
  - **Regras de Negócio**: Regras importantes que devem ser respeitadas
  - **Integrações**: Como se relaciona com outros domínios
  - **Evoluções Futuras**: Ideias e melhorias planejadas

---

**Última atualização**: Janeiro 2026
