# 🧪 Guia de Testes - Sprint 1: Formulário Público

## Ordem Recomendada de Testes

### 1️⃣ **Backend - Migrations e Estrutura** (Primeiro)

#### 1.1 Verificar se o Docker está rodando
```bash
# Na raiz do projeto
cd docker
docker-compose ps
```

#### 1.2 Executar migrations
```bash
# Na raiz do projeto
cd docker
docker-compose exec app php artisan migrate

# Ou se estiver rodando localmente (sem Docker)
cd backend
php artisan migrate
```

#### 1.3 Verificar se as tabelas foram criadas
```bash
cd docker
docker-compose exec app php artisan migrate:status
```

**O que verificar:**
- ✅ `prospects` table criada
- ✅ `prospect_themes` table criada
- ✅ Sem erros de migration

---

### 2️⃣ **Backend - Rotas e Controller** (Segundo)

#### 2.1 Verificar rotas registradas
```bash
cd docker
docker-compose exec app php artisan route:list | grep prospect
```

**Rotas esperadas:**
- `GET  /manifestar-interesse` → `PublicProspectController@show`
- `POST /manifestar-interesse` → `PublicProspectController@store`
- `GET  /manifestar-interesse/obrigado` → `PublicProspectController@thanks`

#### 2.2 Testar rotas via curl (sem frontend)
```bash
# Testar GET do formulário (porta 8080 conforme docker-compose)
curl http://localhost:8080/manifestar-interesse

# Deve retornar HTML do formulário (status 200)
```

#### 2.3 Testar validação do Form Request
```bash
# Testar POST sem dados (deve retornar erros de validação)
curl -X POST http://localhost:8080/manifestar-interesse \
  -H "Content-Type: application/x-www-form-urlencoded" \
  -d ""

# Deve retornar erros de validação em JSON ou HTML
```

---

### 3️⃣ **Frontend - Renderização** (Terceiro)

#### 3.1 Acessar formulário no navegador
```
http://localhost:8080/manifestar-interesse
```

**O que verificar:**
- ✅ Página carrega sem erros
- ✅ Formulário renderiza todos os campos
- ✅ Layout responsivo funciona
- ✅ Campos obrigatórios estão marcados com `*`
- ✅ Temas aparecem como checkboxes

#### 3.2 Verificar estrutura do formulário
- [ ] Bloco A: Identificação (Nome, Email, WhatsApp, LinkedIn)
- [ ] Bloco B: Perfil (Tipo org, Nome org, Cargo, Localização)
- [ ] Bloco C: Sobre a Iniciativa (O que fazem, Problema, Estágio)
- [ ] Bloco D: Pauta e Valor (Temas, Tópicos, História, Pedido)
- [ ] Bloco E: Disponibilidade (Formato, Período, Janela)
- [ ] Bloco F: Consentimento (Checkbox)

---

### 4️⃣ **Fluxo Completo - Envio do Formulário** (Quarto)

#### 4.1 Preencher formulário completo
Preencha todos os campos obrigatórios:
- Nome completo
- E-mail válido
- Tipo de organização
- Nome da organização
- Cargo/função
- Cidade/Estado
- O que fazem
- Problema que resolvem
- Estágio
- Pelo menos 1 tema selecionado
- 3 tópicos que domina
- História/caso real
- Formato preferido
- Melhor período
- Consentimento marcado

#### 4.2 Enviar formulário
Clique em "Enviar Manifestação de Interesse"

**O que verificar:**
- ✅ Redireciona para `/manifestar-interesse/obrigado`
- ✅ Mensagem de sucesso aparece
- ✅ Prospect foi criado no banco

#### 4.3 Verificar dados no banco
```bash
# Verificar se o prospect foi criado
cd docker
docker-compose exec app php artisan tinker

# No tinker:
$prospect = \App\Models\Prospect::latest()->first();
$prospect->toArray();
$prospect->themes; // Verificar temas associados
```

**O que verificar:**
- ✅ Prospect criado com `origin = 'inbound_form'`
- ✅ Prospect criado com `status = 'to_review'`
- ✅ `created_by = null` (cadastro público
- ✅ Temas associados corretamente
- ✅ Todos os campos preenchidos estão salvos

---

### 5️⃣ **Testes de Validação** (Quinto)

#### 5.1 Testar campos obrigatórios
Tente enviar o formulário sem preencher campos obrigatórios:

- [ ] Sem nome → erro
- [ ] Sem e-mail → erro
- [ ] E-mail inválido → erro
- [ ] Sem tipo de organização → erro
- [ ] Sem temas selecionados → erro
- [ ] Sem consentimento → erro

#### 5.2 Testar mensagens de erro
Verifique se as mensagens aparecem em português e são claras.

---

### 6️⃣ **Testes de Edge Cases** (Sexto)

#### 6.1 Campos opcionais
- [ ] WhatsApp vazio → aceita
- [ ] LinkedIn vazio → aceita
- [ ] Janela de disponibilidade vazia → aceita
- [ ] Pedido para ecossistema vazio → aceita

#### 6.2 Múltiplos temas
- [ ] Selecionar 1 tema → funciona
- [ ] Selecionar vários temas → todos são salvos
- [ ] Não selecionar nenhum tema → erro

#### 6.3 Dados longos
- [ ] Textos muito longos → validação funciona
- [ ] E-mail muito longo → validação funciona

---

## 🐛 Troubleshooting

### Erro: "Table 'prospects' doesn't exist"
```bash
# Executar migrations
cd docker
docker-compose exec app php artisan migrate
```

### Erro: "Route not found"
```bash
# Limpar cache de rotas
cd docker
docker-compose exec app php artisan route:clear
docker-compose exec app php artisan cache:clear
```

### Erro: "Class 'Prospect' not found"
```bash
# Limpar cache de autoload
cd docker
docker-compose exec app composer dump-autoload
```

### Formulário não renderiza
```bash
# Limpar cache de views
cd docker
docker-compose exec app php artisan view:clear
```

### Erro de validação não aparece
- Verificar se `@error` está sendo usado nas views
- Verificar se Form Request está retornando erros corretamente

---

## ✅ Checklist Final

Antes de considerar o Sprint 1 completo, verifique:

- [ ] Migrations executadas sem erros
- [ ] Rotas registradas e acessíveis
- [ ] Formulário renderiza corretamente
- [ ] Validação funciona para todos os campos
- [ ] Prospect é criado no banco após envio
- [ ] Temas são associados corretamente
- [ ] Página de agradecimento aparece após envio
- [ ] Mensagens de erro são claras e em português
- [ ] Layout é responsivo (mobile/desktop)
- [ ] Sem erros no console do navegador

---

## 🚀 Próximos Passos

Após validar todos os testes acima, o Sprint 1 está completo e você pode:
1. Começar o Sprint 2 (Base do Sistema - CRUD interno)
2. Fazer ajustes finos no formulário se necessário
3. Adicionar testes automatizados (opcional)
