# Domínio de Calendário

## 📋 Responsabilidades

O domínio de **Calendário** fornece visão temporal e planejamento editorial, permitindo visualizar e gerenciar o cronograma de produção e publicação dos episódios.

## 🎯 Funcionalidades Principais

### Visualização Temporal
- Calendário mensal/semanal com episódios
- Eventos baseados em datas do episódio:
  - Data de gravação (`record_date`)
  - Data de publicação (`publish_date`)
- Diferenciação visual por status do episódio

### Planejamento Editorial
- Identificação de "buracos" no calendário
- Alertas de semanas sem publicação prevista
- Previsibilidade de publicação
- Ritmo editorial (média de episódios por período)

### Eventos e Marcos
- Eventos do ecossistema (futuro)
- Feriados e datas importantes
- Marcos editoriais (ex: episódio #100)

## 🔄 Relacionamentos

```
Calendário ──→ Episódio (via record_date, publish_date)
Calendário ──→ Tarefa Editorial (via due_date)
```

## 📐 Regras de Negócio Críticas

1. **Eventos do Calendário**:
   - Episódios aparecem no calendário baseado em `record_date` e `publish_date`
   - Ambos os eventos podem aparecer (gravação e publicação)
   - Eventos são opcionais (episódio pode não ter datas definidas)

2. **Visualização**:
   - Diferenciação visual por status do episódio
   - Cores diferentes para gravação vs. publicação
   - Filtros por status, tema, convidado

3. **Alertas**:
   - Semanas sem episódios agendados
   - Episódios próximos do prazo de publicação
   - Tarefas vencidas (se integrado)

4. **Ritmo Editorial**:
   - Cálculo de média de episódios por mês
   - Identificação de períodos de pico e queda
   - Comparação com meta editorial (se definida)

## 🔗 Integrações com Outros Domínios

- **Editorial**: Episódios aparecem no calendário
- **Operacional**: Tarefas com prazo podem aparecer no calendário
- **Inteligência**: Análise de ritmo e cadência editorial

## 🚀 Evoluções Futuras

- [ ] Export iCal / Google Calendar
- [ ] Integração com calendários externos
- [ ] Eventos do ecossistema (hackathons, eventos, etc.)
- [ ] Simulação de cenários ("e se publicarmos 2 episódios por semana?")
- [ ] Alertas de impacto de feriados e eventos
- [ ] Aprendizado de melhor dia da semana para publicação
- [ ] Visualização de pipeline completo no calendário
- [ ] Drag-and-drop para reagendamento de episódios

## 📊 Métricas do Calendário

- Episódios agendados para próximos 7/14/30 dias
- Semanas sem publicação prevista
- Ritmo editorial (média mensal)
- Variação de ritmo ao longo do tempo

## 💡 Insights do Calendário

- **Previsibilidade**: Quantos episódios estão no pipeline?
- **Ritmo**: Estamos mantendo o ritmo editorial desejado?
- **Buracos**: Há períodos sem publicação prevista?
- **Picos**: Há sobrecarga em determinados períodos?

---

**Responsável por**: Visão temporal e planejamento editorial
