# Sprints de Implementação — Sistema de Curadoria

## 🎯 Objetivo

Implementar o sistema de curadoria de forma incremental, priorizando o **formulário público** para captação imediata e depois a base do sistema para gestão interna.

## 📊 Visão Geral das Sprints

```
Sprint 1: Formulário Público (MVP de Captação)
    ↓
Sprint 2: Base do Sistema (Models, Migrations, CRUD)
    ↓
Sprint 3: Pipeline e Status (Workflow Básico)
    ↓
Sprint 4: Assistente do Curador (Templates, Logs)
    ↓
Sprint 5: Melhorias e Refinamentos
```

---

## 🚀 Sprint 1: Formulário Público (MVP de Captação)

**Objetivo**: Permitir que prospects se cadastrem via formulário público.

**Prioridade**: 🔴 ALTA (permite captação imediata)

**Duração estimada**: 3-5 dias

### Entregas

1. ✅ Migration `create_prospects_table` (campos básicos do formulário)
2. ✅ Model `Prospect` (campos básicos)
3. ✅ Migration `create_prospect_themes_table`
4. ✅ Controller `PublicProspectController`
5. ✅ Form Request `StorePublicProspectRequest`
6. ✅ View do formulário público (`public/prospects/form.blade.php`)
7. ✅ View de agradecimento (`public/prospects/thanks.blade.php`)
8. ✅ Rotas públicas

### Campos Mínimos do Formulário (Sprint 1)

**Identificação**:
- Nome completo ✅
- E-mail ✅
- WhatsApp (opcional)
- LinkedIn (opcional)

**Perfil**:
- Tipo de organização ✅
- Nome da organização ✅
- Cargo/função ✅
- Cidade/Estado ✅

**Sobre a Iniciativa**:
- O que fazem ✅
- Problema que resolvem ✅
- Estágio ✅

**Pauta e Valor**:
- Temas (seleção múltipla) ✅
- 3 tópicos que domina ✅
- História/caso real ✅
- Pedido para ecossistema (opcional)

**Disponibilidade**:
- Formato preferido ✅
- Melhor período ✅
- Janela de disponibilidade (opcional)

**Consentimento**:
- Checkbox obrigatório ✅

### Migration Simplificada (Sprint 1)

```php
// Apenas campos essenciais para o formulário público
Schema::create('prospects', function (Blueprint $table) {
    $table->id();
    
    // Identificação (formulário)
    $table->enum('type', ['person', 'company'])->default('person');
    $table->string('name');
    $table->string('email');
    $table->string('whatsapp', 20)->nullable();
    $table->string('linkedin_url')->nullable();
    
    // Perfil (formulário)
    $table->string('role_title')->nullable();
    $table->string('company_name')->nullable();
    $table->enum('organization_type', ['startup', 'empresa', 'governo', 'academia', 'osc', 'hub', 'outro'])->nullable();
    $table->string('location')->nullable();
    
    // Sobre a Iniciativa (formulário)
    $table->text('what_they_do')->nullable();
    $table->text('problem_solved')->nullable();
    $table->enum('stage', ['ideacao', 'mvp', 'tracao', 'escala', 'consolidacao'])->nullable();
    
    // Pauta e Valor (formulário)
    $table->text('expertise_topics')->nullable();
    $table->text('story_case')->nullable();
    $table->text('ecosystem_request')->nullable();
    
    // Disponibilidade (formulário)
    $table->enum('preferred_format', ['presencial', 'online'])->nullable();
    $table->enum('preferred_time', ['manha', 'tarde', 'noite'])->nullable();
    $table->text('availability_window')->nullable();
    $table->boolean('consent_given')->default(false);
    
    // Curadoria (mínimo)
    $table->enum('origin', ['inbound_form', 'outbound_curated', 'referral', 'event', 'other'])->default('inbound_form');
    $table->string('status', 50)->default('to_review');
    $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
    $table->timestamps();
    
    $table->index('status');
    $table->index('origin');
    $table->index('email');
});
```

### Critérios de Aceitação

- [ ] Formulário público acessível sem autenticação
- [ ] Todos os campos obrigatórios validados
- [ ] Prospect criado com `origin = inbound_form` e `status = to_review`
- [ ] Temas associados corretamente
- [ ] Página de agradecimento exibida após submissão
- [ ] Dados salvos corretamente no banco
- [ ] Mensagens de erro claras em português

### Notas Técnicas

- **Não precisa** de score, prioridade, notas editoriais ainda
- **Não precisa** de relacionamento com Guest ainda
- **Foco**: Captar dados do formulário e salvar

---

## 🏗️ Sprint 2: Base do Sistema (Models, Migrations, CRUD)

**Objetivo**: Estrutura completa do banco de dados e CRUD básico para gestão interna.

**Prioridade**: 🟡 MÉDIA (base para tudo)

**Duração estimada**: 5-7 dias

### Entregas

1. ✅ Migration completa `create_prospects_table` (todos os campos)
2. ✅ Model `Prospect` completo (relacionamentos, métodos)
3. ✅ Migration `create_prospect_themes_table`
4. ✅ Migration `add_prospect_id_to_guests_table`
5. ✅ Atualização do Model `Guest` (relacionamento com Prospect)
6. ✅ Controller `ProspectController` (CRUD completo)
7. ✅ Form Requests (`StoreProspectRequest`, `UpdateProspectRequest`)
8. ✅ Views básicas (index, show, create, edit)
9. ✅ Rotas autenticadas

### Campos Adicionais (Sprint 2)

**Curadoria**:
- `priority` (1-5)
- `notes` (justificativa editorial)
- `fit_score`, `impact_potential`, `timing_score`, `total_score`
- `diversity_flags` (JSON)
- `rejection_reason`

**Agendamento**:
- `preferred_slots`
- `scheduled_at`
- `meeting_link`

### Funcionalidades

- [ ] Listar prospects (com filtros básicos)
- [ ] Visualizar prospect detalhado
- [ ] Criar prospect manualmente (outbound_curated)
- [ ] Editar prospect
- [ ] Aprovar prospect
- [ ] Rejeitar prospect (com motivo)
- [ ] Filtros: status, origin, tipo
- [ ] Busca por nome/email

### Critérios de Aceitação

- [ ] Todos os campos do modelo implementados
- [ ] Relacionamentos funcionando (themes, guest, creator)
- [ ] Score total calculado automaticamente
- [ ] CRUD completo funcional
- [ ] Validações em português
- [ ] Interface básica funcional

### Notas Técnicas

- Implementar `booted()` no Model para calcular `total_score`
- Relacionamento com Guest via `guests.prospect_id` (único)
- Views podem ser simples (tabela, formulários básicos)

---

## 🔄 Sprint 3: Pipeline e Status (Workflow Básico)

**Objetivo**: Gerenciar o pipeline de status e transições.

**Prioridade**: 🟡 MÉDIA (workflow essencial)

**Duração estimada**: 3-5 dias

### Entregas

1. ✅ Migration `create_prospect_status_logs_table`
2. ✅ Model `ProspectStatusLog`
3. ✅ Registro automático de mudanças de status (via `booted()`)
4. ✅ Método `updateStatus()` no Controller
5. ✅ View Kanban ou Tabela com status
6. ✅ Ações rápidas (aprovar, rejeitar, atualizar status)
7. ✅ Timeline básica na view de detalhe

### Status do Pipeline

- `to_review` → `approved` → `invited` → `in_conversation` → `scheduled` → `confirmed`
- `rejected` (com motivo)
- `archived`

### Funcionalidades

- [ ] Visualizar prospects por status (Kanban ou Tabela)
- [ ] Arrastar cards entre colunas (se Kanban)
- [ ] Atualizar status com um clique
- [ ] Timeline de mudanças de status
- [ ] Validação de transições de status
- [ ] Log automático de mudanças

### Critérios de Aceitação

- [ ] Todos os status do pipeline funcionando
- [ ] Transições de status validadas
- [ ] Logs de status registrados automaticamente
- [ ] Timeline exibindo histórico
- [ ] Interface clara do pipeline

### Notas Técnicas

- Implementar validação de transições (ex: não pode voltar de `approved` para `to_review`)
- Timeline pode ser simples (lista cronológica)

---

## 🤖 Sprint 4: Assistente do Curador (Templates, Logs)

**Objetivo**: Funcionalidades avançadas para otimizar o trabalho de curadoria.

**Prioridade**: 🟢 BAIXA (melhoria de produtividade)

**Duração estimada**: 5-7 dias

### Entregas

1. ✅ Config `prospect_invites.php` (templates)
2. ✅ Método `generateInvite()` no Controller
3. ✅ Migration `create_prospect_contacts_table`
4. ✅ Model `ProspectContact`
5. ✅ Método `logContact()` no Controller
6. ✅ Migration `create_prospect_intake_tokens_table`
7. ✅ Model `ProspectIntakeToken`
8. ✅ Método `generateIntakeLink()` no Controller
9. ✅ Migration `create_guest_intake_submissions_table`
10. ✅ Model `GuestIntakeSubmission`
11. ✅ Controller `PublicGuestIntakeController` (formulário público)
12. ✅ Método `scheduleInterview()` no Controller

### Funcionalidades

- [ ] Gerar convite (templates por tipo)
- [ ] Copiar convite pronto (email, WhatsApp, LinkedIn)
- [ ] Registrar envio de contato
- [ ] Gerar link único de ficha do convidado
- [ ] Formulário público de ficha do convidado
- [ ] Agendar entrevista (cria episódio automaticamente)
- [ ] Timeline completa (contatos + status)

### Critérios de Aceitação

- [ ] Templates funcionando e personalizáveis
- [ ] Logs de contato registrados
- [ ] Links únicos gerados e funcionando
- [ ] Formulário de ficha do convidado funcional
- [ ] Agendamento cria episódio + guest + tasks
- [ ] Timeline completa na view de detalhe

### Notas Técnicas

- Templates podem começar simples (3 tipos: startup, governo, default)
- Envio de e-mail pode ser manual no MVP (copiar e colar)
- Integração SMTP pode ficar para Sprint 5

---

## ✨ Sprint 5: Melhorias e Refinamentos

**Objetivo**: Polimento, integrações e melhorias de UX.

**Prioridade**: 🟢 BAIXA (nice to have)

**Duração estimada**: 5-7 dias

### Entregas

1. ✅ Integração SMTP (envio automático de e-mails)
2. ✅ Dashboard de métricas (insights básicos)
3. ✅ Relatórios (taxa de conversão, tempo médio no funil)
4. ✅ Filtros avançados
5. ✅ Export de dados
6. ✅ Notificações (alertas de prospects parados)
7. ✅ Melhorias de UX (animações, feedback visual)
8. ✅ Testes automatizados

### Funcionalidades

- [ ] Enviar e-mail diretamente pelo sistema
- [ ] Dashboard com métricas de curadoria
- [ ] Relatórios exportáveis
- [ ] Alertas automáticos
- [ ] Busca avançada
- [ ] Filtros combinados
- [ ] Testes de integração

### Critérios de Aceitação

- [ ] E-mails enviados automaticamente
- [ ] Dashboard funcional com métricas
- [ ] Relatórios gerados corretamente
- [ ] Alertas funcionando
- [ ] Testes passando
- [ ] Performance adequada

---

## 📋 Checklist de Dependências

### Sprint 1 → Sprint 2
- Migration do Sprint 1 deve ser expandida (não criar nova)
- Model do Sprint 1 deve ser expandido

### Sprint 2 → Sprint 3
- Model `Prospect` completo
- Controller básico funcionando

### Sprint 3 → Sprint 4
- Pipeline de status funcionando
- Logs de status implementados

### Sprint 4 → Sprint 5
- Base completa do sistema
- Assistente do Curador funcional

---

## 🎯 Priorização Final

### Fase 1: MVP de Captação (Sprint 1)
**Objetivo**: Captar prospects via formulário público
**Tempo**: 3-5 dias
**Valor**: 🔴 ALTO (permite começar a captar)

### Fase 2: Base Operacional (Sprint 2 + 3)
**Objetivo**: Gestão interna completa
**Tempo**: 8-12 dias
**Valor**: 🟡 MÉDIO (necessário para operar)

### Fase 3: Produtividade (Sprint 4)
**Objetivo**: Otimizar trabalho de curadoria
**Tempo**: 5-7 dias
**Valor**: 🟢 BAIXO (melhoria de produtividade)

### Fase 4: Polimento (Sprint 5)
**Objetivo**: Integrações e refinamentos
**Tempo**: 5-7 dias
**Valor**: 🟢 BAIXO (nice to have)

---

## 📊 Roadmap Visual

```
Sprint 1 (3-5 dias)
├── Formulário Público ✅
└── Captação de Prospects ✅

Sprint 2 (5-7 dias)
├── Models Completos ✅
├── Migrations Completas ✅
└── CRUD Básico ✅

Sprint 3 (3-5 dias)
├── Pipeline de Status ✅
├── Logs Automáticos ✅
└── Timeline ✅

Sprint 4 (5-7 dias)
├── Templates de Convite ✅
├── Logs de Contato ✅
├── Ficha do Convidado ✅
└── Agendamento ✅

Sprint 5 (5-7 dias)
├── Integrações ✅
├── Dashboard ✅
└── Refinamentos ✅
```

---

**Total estimado**: 21-36 dias (4-7 semanas)

**Recomendação**: Focar em Sprint 1 + Sprint 2 para ter um MVP funcional completo.
