# Domínio de Curadoria

## 📋 Responsabilidades

O domínio de **Curadoria** gerencia o pipeline de relacionamento desde a identificação de prospects até a confirmação como convidados. Resolve problemas críticos de qualidade, diversidade e rastreabilidade editorial.

## 🎯 Problemas que Resolve

### 1. Qualidade Editorial
- **Quem faz sentido para o posicionamento do podcast?**
- Avaliação criteriosa antes de convidar
- Score de fit editorial

### 2. Diversidade
- **Evitar bolha** (sempre os mesmos perfis/organizações)
- Flags de diversidade (academia, gov, startup, periferia, etc.)
- Análise de representatividade

### 3. Rastreabilidade
- **Por que convidamos / por que não convidamos?**
- Histórico de decisões editoriais
- Justificativas documentadas

### 4. Pipeline de Relacionamento
- Prospect → Contato → Confirmado → Gravado → Publicado → Follow-up
- Visibilidade do status de cada prospect
- Alertas de gargalos no funil

### 5. Captação Pública
- **Formulário público** para manifestação de interesse
- Alimenta diretamente o módulo de Curadoria
- Alto volume, baixa fricção (ex: Café com Startups do Worktiba)
- Reduz dependência de indicações informais

## 🎯 Entidades Principais

### Prospect (`prospects`)
**Papel**: Cadastro de prospects (pessoas ou empresas) antes de se tornarem convidados.

**Características**:
- Representa pessoa OU empresa (flexível no MVP)
- Passa por pipeline de curadoria
- Pode ser convertido em Guest quando aprovado

**Campos-chave**:

**Identificação**:
- `type` (person | company) - Tipo de prospect
- `name` - Nome da pessoa ou empresa
- `email` - E-mail de contato
- `whatsapp` (opcional) - WhatsApp
- `linkedin_url`, `website_url` (opcional) - Links

**Perfil**:
- `role_title` (opcional, se person) - Cargo/atuação
- `company_name` (opcional, se person) - Empresa da pessoa
- `organization_type` (startup/empresa/governo/academia/osc/hub/outro) - Tipo de organização
- `sector` (opcional) - Categoria/setor
- `location` (opcional) - Cidade/Estado

**Sobre a Iniciativa** (captação pública):
- `what_they_do` (opcional) - Em uma frase: o que fazem?
- `problem_solved` (opcional) - Qual problema resolvem e para quem?
- `stage` (ideacao/mvp/tracao/escala/consolidacao) - Estágio atual

**Pauta e Valor** (captação pública):
- `expertise_topics` (opcional) - 3 tópicos que domina
- `story_case` (opcional) - História/caso real para compartilhar
- `ecosystem_request` (opcional) - Pedido para o ecossistema

**Disponibilidade** (captação pública):
- `preferred_format` (presencial/online) - Formato preferido
- `preferred_time` (manha/tarde/noite) - Melhor período
- `availability_window` (opcional) - Janela de disponibilidade (próximas 3 semanas)
- `consent_given` (boolean) - Autorização de contato

**Curadoria**:
- `origin` - Origem (inbound_form, outbound_curated, referral, event, other)
- `status` - Status no pipeline (ver abaixo)
- `priority` (1-5) - Prioridade editorial
- `notes` - Justificativa editorial
- `fit_score` (1-5) - Score de fit editorial
- `impact_potential` (1-5) - Potencial de impacto
- `timing_score` (1-5) - Score de timing
- `total_score` (3-15) - Score total (fit + impacto + timing)
- `diversity_flags` (JSON) - Flags de diversidade
- `rejection_reason` (opcional) - Motivo da rejeição
- `created_by` (FK → users, nullable) - Quem cadastrou (NULL se formulário público)
- `created_at`, `updated_at`

**Regras de Negócio**:
- Prospect pode ser pessoa OU empresa
- Se `type = person`: campos de pessoa + `company_name` opcional
- Se `type = company`: apenas campos de empresa
- Prospect aprovado pode ser convertido em Guest
- Prospect rejeitado mantém histórico (não deleta)

### Relação Prospect ↔ Tema (`prospect_themes`)
**Tipo**: Entidade associativa (N:N)

**Campos-chave**:
- `prospect_id` (FK → prospects)
- `theme_id` (FK → themes)

**Regras de Negócio**:
- Prospect pode estar relacionado a múltiplos temas
- Permite análise de fit temático
- Usado para sugerir prospects baseado em temas do episódio

## 🎯 Conceito: 1 Funil, 2 Origens

O sistema unifica o pipeline de curadoria para **todas as origens**:

- **Quem se candidata** → `origin = inbound_form` (formulário público)
- **Quem vocês querem convidar** → `origin = outbound_curated` (curadoria ativa)
- **Outras origens**: `referral`, `event`, `other`

**Benefício**: Governança única, sem duplicar entidades. Ambos seguem o mesmo pipeline.

## 🔄 Pipeline de Status (Funil de Curadoria Expandido)

O prospect passa por um funil completo que cobre todo o ciclo:

```
to_review → approved → invited → in_conversation → scheduled → confirmed → recorded → published → follow_up
                                                                              ↓
                                                                          rejected (com motivo)
                                                                              ↓
                                                                          archived
```

### Status do Pipeline

1. **`to_review`** - Na fila de curadoria
   - Prospect cadastrado, aguardando avaliação
   - Ação: Revisar e aprovar/rejeitar

2. **`approved`** - Curadoria OK
   - Aprovado para convite
   - Ação: Gerar e enviar convite

3. **`invited`** - Convite enviado
   - Convite foi enviado (e-mail, WhatsApp, LinkedIn)
   - Ação: Acompanhar resposta

4. **`in_conversation`** - Em conversa
   - Prospect respondeu, dialogando sobre participação
   - Ação: Negociar data/condições, enviar ficha do convidado

5. **`scheduled`** - Agendado
   - Data de gravação confirmada
   - Ação: Preparar episódio, criar tarefas

6. **`confirmed`** - Confirmado
   - Pronto para gravar, todos os detalhes confirmados
   - Ação: Converter em Guest e criar episódio

7. **`recorded`** - Gravado
   - Episódio foi gravado
   - Ação: Seguir workflow normal do episódio

8. **`published`** - Publicado
   - Episódio foi publicado
   - Ação: Follow-up com convidado

9. **`follow_up`** - Follow-up realizado
   - Acompanhamento pós-publicação feito
   - Ação: Arquivar ou manter para futuros convites

10. **`rejected`** - Rejeitado (com motivo)
    - Não aprovado para convite
    - Campo `rejection_reason` obrigatório
    - Mantém histórico para aprendizado

11. **`archived`** - Arquivado
    - Prospect antigo ou inativo
    - Mantém histórico

### Transições de Status

- `to_review` → `approved` (aprovação)
- `to_review` → `rejected` (rejeição com motivo)
- `approved` → `invited` (convite enviado)
- `invited` → `in_conversation` (respondeu)
- `in_conversation` → `scheduled` (agendou)
- `scheduled` → `confirmed` (confirmou)
- `confirmed` → `recorded` (gravado - quando episódio é criado)
- `recorded` → `published` (publicado - quando episódio é publicado)
- `published` → `follow_up` (follow-up realizado)
- Qualquer status → `archived` (arquivar)

## 📊 Critérios de Curadoria

### Score Editorial (MVP)

Três notas simples (1-5 cada):
- **Fit** (1-5): Quanto faz sentido para o posicionamento?
- **Impacto** (1-5): Potencial de impacto editorial
- **Timing** (1-5): Momento certo para convidar?

**Score Total** = Fit + Impacto + Timing (3-15)

### Flags de Diversidade

Campos simples para evitar bolha:
- `diversity_flags` (JSON ou string separada por vírgula)
- Exemplos: `academia`, `gov`, `startup`, `periferia`, `mulher`, `negro`, `lgbtqia+`, etc.

### Análise Temática

- Prospect relacionado a temas (N:N)
- Permite sugerir prospects baseado em temas do episódio
- Análise de diversidade temática

## 🔄 Relacionamentos

```
Prospect (N) ──→ (1) Usuário (criador)
Prospect (N) ←──→ (N) Tema (via prospect_themes)
Prospect (1) ──→ (0..1) Guest (quando convertido)
```

## 📐 Regras de Negócio Críticas

1. **Conversão em Guest**:
   - Prospect com status `confirmed` pode ser convertido em Guest
   - Conversão copia dados relevantes do prospect para o guest
   - Prospect mantém referência ao guest criado (opcional)
   - Prospect pode ser arquivado após conversão

2. **Rejeição**:
   - Prospect rejeitado DEVE ter `rejection_reason` preenchido
   - Rejeição mantém histórico (não deleta)
   - Permite aprendizado e análise de padrões

3. **Prioridade**:
   - Priority (1-5) ajuda a ordenar prospects
   - Pode ser usado para alertas ("prospect de alta prioridade parado")

4. **Origin (Origem)**:
   - Registra de onde veio o prospect
   - Valores: `inbound_form`, `outbound_curated`, `referral`, `event`, `other`
   - `inbound_form`: Quem se candidatou (formulário público)
   - `outbound_curated`: Quem vocês querem convidar (curadoria ativa)
   - Permite análise: "quais origens geram melhores convidados?"
   - Formulário público sempre cria prospect com `origin = 'inbound_form'`

5. **Formulário Público**:
   - Prospect criado via formulário público tem `created_by = NULL`
   - Status inicial sempre `to_review`
   - Dados completos do formulário são preservados
   - Permite rastreabilidade de origem

6. **Diversidade**:
   - Flags de diversidade são opcionais
   - Permite análise de representatividade
   - Não deve ser obrigatório (evita viés)
   - Pode ser preenchido automaticamente baseado em `organization_type`

## 🔗 Integrações com Outros Domínios

- **Editorial**: Prospect relacionado a temas, pode virar Guest
- **Governança**: Prospect criado por usuário
- **Operacional**: Prospect pode gerar tarefas de follow-up
- **Inteligência**: Análise de pipeline, fontes, diversidade
- **Calendário**: Prospects agendados aparecem no calendário

## 🚀 Evoluções Futuras

- [ ] Score automático baseado em histórico
- [ ] Sugestão de prospects baseada em temas do episódio
- [ ] Integração com LinkedIn API (buscar informações)
- [ ] Alertas automáticos de prospects parados
- [ ] Análise de diversidade visual (gráficos)
- [ ] Templates de mensagem por fonte
- [ ] Histórico de interações com prospect
- [ ] Integração com CRM externo

## 📊 Insights que a Curadoria Habilita

### 1. Análise de Fontes
- Quais fontes geram melhores convidados? (eventos, indicações, inbound)
- Taxa de conversão por fonte (prospect → guest)
- Tempo médio no funil por fonte

### 2. Análise de Diversidade
- Quais setores estão sub-representados?
- Distribuição de perfis (academia, gov, startup, etc.)
- Identificação de lacunas de diversidade

### 3. Análise de Pipeline
- Quanto tempo um prospect fica no funil até gravar?
- Onde o funil trava? (aprovados não contatados, etc.)
- Taxa de conversão por etapa

### 4. Análise Temática
- Quais temas têm pouca oferta de convidados qualificados?
- Distribuição de prospects por tema
- Identificação de temas com baixa representatividade

### 5. Análise de Qualidade
- Score médio de prospects aprovados vs. rejeitados
- Padrões de rejeição (motivos mais comuns)
- Relação entre score e sucesso (conversão em guest)

## 💡 Alertas e Notificações

- "Tem 10 prospects aprovados e ninguém contatou"
- "Prospect de alta prioridade parado há mais de X dias"
- "Nenhum prospect agendado para as próximas semanas"
- "Taxa de rejeição aumentou este mês"

## 🎨 UX/Telas (Especificação)

### Tela: "Curadoria" (`/curation`)

**Menu novo**: Curadoria

**Visões**:

1. **Kanban por Status** (recomendado)
   - Colunas: to_review → approved → contacted → in_conversation → scheduled → confirmed
   - Cards arrastáveis entre colunas
   - Filtros: tipo, prioridade, fonte, tema

2. **Tabela com Filtros** (alternativa MVP)
   - Mais rápida de implementar
   - Filtros: status, tipo, prioridade, fonte, tema
   - Ordenação: prioridade, score, data

**Ações rápidas por card/linha**:
- Aprovar / Rejeitar (com motivo obrigatório)
- Marcar como contatado
- Criar tarefa "follow-up"
- Converter em Guest (quando confirmado)
- Editar prospect
- Ver histórico

**Filtros e Busca**:
- Por status
- Por tipo (person/company)
- Por prioridade
- Por origem (inbound_form, outbound_curated, etc.)
- Por tema relacionado
- Por score
- Busca por nome

### Tela: "Detalhe do Prospect" (`/prospects/{id}`)

**Uma tela que resolve tudo** - Curadoria + Prospect em um só lugar.

**Botões de Ação no Topo**:
- **Aprovar / Rejeitar** - Aprovação rápida com motivo
- **Gerar Convite** - Abre gerador de convite (templates)
- **Registrar Envio** - Registra tentativa de contato
- **Enviar Ficha do Convidado** - Gera e envia link único
- **Marcar Entrevista** - Agendamento assistido
- **Converter para Guest** - Quando confirmado

**Seção Lateral**:
- Status atual + badge de origem
- Prioridade (1-5) com indicador visual
- Score total (fit + impacto + timing)
- Tags/Temas relacionados
- Informações rápidas (e-mail, WhatsApp, LinkedIn)

**Seção Principal**:
- **Perfil do Prospect**: Todos os dados coletados
- **Notas Editoriais**: Campo para anotações internas
- **Timeline de Contatos**: Linha do tempo de interações
  - Criado (origem)
  - Aprovado
  - Convite enviado
  - Respondeu
  - Agendado
  - Confirmado
  - Gravado
  - Publicado
  - Follow-up

**Benefícios**:
- Rastreabilidade completa
- Memória institucional
- Previsibilidade do pipeline
- Ações rápidas sem sair da tela

## 📝 Formulário Público de Captação

### Objetivo

Alimentar diretamente o módulo de Curadoria sem depender de indicações informais. O formulário público permite:
- Alto volume de prospects
- Baixa fricção de entrada
- Narrativa clara sobre o processo
- Redução de dependência de indicações

### Posicionamento (Mensagens-chave)

**Importante**: É manifestação de interesse, não inscrição.

Mensagens para comunicar:
- "O link é para manifestar interesse em participar de entrevistas."
- "A seleção é curada, alinhada com a pauta e agenda editorial."
- "Todos que preencherem entram no radar e podem ser chamados em ciclos futuros."

**Benefícios**:
- Reduz atrito e expectativas erradas
- Evita "cadê minha entrevista?" na semana seguinte
- Deixa claro que é um processo curado

### Estrutura do Formulário (MVP)

#### Bloco A — Identificação
- Nome completo (obrigatório)
- E-mail (obrigatório)
- WhatsApp (opcional, mas recomendado)
- LinkedIn (opcional, mas recomendado)

#### Bloco B — Perfil (Pessoa / Organização)
- Você representa: ( ) Startup ( ) Empresa ( ) Governo ( ) Academia ( ) OSC ( ) Hub/Ambiente ( ) Outro
- Nome da organização (obrigatório)
- Seu cargo/função (obrigatório)
- Cidade/Estado (obrigatório)

#### Bloco C — Sobre a Iniciativa
- Em uma frase: o que vocês fazem? (texto curto, obrigatório)
- Qual problema vocês resolvem e para quem? (texto curto, obrigatório)
- Qual estágio hoje? ( ) Ideação ( ) MVP ( ) Tração ( ) Escala ( ) Consolidação

#### Bloco D — Pauta e Valor da Entrevista
- Qual tema você gostaria de abordar no podcast? (seleção múltipla + "outro")
  - GovTech, Smart Cities, Inovação Corporativa, Startups, Investimento, Talentos, Tecnologia, Impacto, etc.
- Quais 3 tópicos você domina e consegue falar com profundidade? (texto curto, obrigatório)
- Qual história/caso real você consegue compartilhar? (texto curto, obrigatório)
- Qual "pedido" você tem para o ecossistema? (ex: parceiros, clientes, talentos, investimento) (texto curto, opcional)

#### Bloco E — Disponibilidade e Logística
- Formato preferido: ( ) Presencial (Curitiba) ( ) Online
- Melhor período para entrevista: ( ) Manhã ( ) Tarde ( ) Noite
- Janela de disponibilidade (próximas 3 semanas) (campo livre, opcional)
- Autorizo contato para curadoria e agendamento (checkbox obrigatório)

#### Bloco F — Consentimento
- Declaração: "Entendo que este formulário é uma manifestação de interesse e que a participação depende de curadoria editorial e disponibilidade de agenda." (checkbox obrigatório)

### Fluxo Após Submissão

1. **Form enviado** → Cria prospect automaticamente
   - Status: `to_review`
   - Source: `formulario_publico`
   - `created_by`: NULL (cadastro público)
   - Dados do formulário mapeados para campos do prospect

2. **Curadoria rápida** (Alan + Américo):
   - Avaliar fit, impacto e timing (1-5 cada)
   - Status vira `approved` ou `rejected` (com motivo)
   - Score total calculado automaticamente

3. **Se aprovado**:
   - Status: `contacted` → `in_conversation` → `scheduled` → `confirmed`
   - Quando confirmado: converter para Guest + criar episódio em "Pauta"
   - Checklist padrão entra automaticamente

### Integração com Sistema Editorial

O formulário público conecta diretamente ao sistema editorial:
- Prospect criado automaticamente
- Relacionamento com temas (N:N)
- Pipeline completo integrado
- Conversão em Guest quando confirmado
- Criação automática de episódio em "Pauta"
- Checklist padrão aplicado

### Rota Pública

- **URL**: `/manifestar-interesse` ou `/quero-participar`
- **Acesso**: Público (sem autenticação)
- **Ação**: POST para criar prospect
- **Resposta**: Mensagem de confirmação e agradecimento

### Texto Pronto para Comunicação

**Exemplo de mensagem para compartilhar**:

> "Quer participar do podcast Vale do Pinhão? 🎙️
> 
> Estamos abrindo um formulário para manifestação de interesse em participar de entrevistas.
> 
> ⚠️ Importante: é uma manifestação de interesse, não uma inscrição direta. A seleção é curada, alinhada com nossa pauta e agenda editorial.
> 
> Todos que preencherem entram no nosso radar e podem ser chamados em ciclos futuros.
> 
> Link: [URL do formulário]"

## 🤖 Assistente do Curador

Funcionalidades que valem ouro para otimizar o trabalho de curadoria.

### A) Gerador de Convite (Templates + Personalização)

**Localização**: Botão "Gerar Convite" na tela de detalhe do prospect.

**Funcionalidade**:
- Seleciona template (ex: startup, governo, academia, empresa)
- Preenche variáveis automaticamente:
  - Nome do prospect
  - Organização
  - Tema sugerido (baseado em temas relacionados)
  - Host (Alan/Américo)
  - Formato (presencial/online)
- Permite editar antes de enviar

**Output**:
- Texto de e-mail completo (pronto para copiar/enviar)
- Texto WhatsApp/LinkedIn (variações curtas)
- Versões personalizadas por canal

**Benefícios**:
- Consistência nas comunicações
- Economiza tempo e neurônios
- Personalização rápida

### B) Envio de E-mail + Registro de Tentativa

**MVP (Sem enviar pelo sistema)**:
- Botão "Copiar e-mail pronto"
- Campo "Data do envio" (manual)
- Status muda para `invited`
- Log de contato registrado: "enviado via e-mail/LinkedIn/WhatsApp"

**Sprint Seguinte (Enviar de fato)**:
- Integração SMTP / serviço (Mailgun, SES, etc.)
- Salvar automaticamente:
  - `sent_at` (timestamp)
  - `subject` (assunto)
  - `message_id` (se aplicável)
  - `channel` (email/whatsapp/linkedin)

**Benefícios**:
- Vira "CRM editorial" sem virar Outlook
- Rastreabilidade de comunicações
- Histórico completo de tentativas

### C) Coleta de Dados (Form do Convidado) com Link Único

**Funcionalidade**:
- Após prospect aceitar, gerar link único de "Ficha do Convidado"
- Link expira após X dias (configurável)
- Prospect preenche:
  - Mini bio
  - Links oficiais
  - Foto (URL ou upload depois)
  - Temas favoritos
  - Disponibilidade
  - Autorização de imagem/voz (termo simples)

**No Sistema**:
- Status `in_conversation` → `scheduled`/`confirmed` quando preencher e agendar
- Dados coletados são salvos automaticamente
- Foto pode ser vinculada ao Guest quando convertido

**Benefícios**:
- Reduz 80% do "me manda sua bio" manual
- Dados estruturados desde o início
- Acelera criação de episódio

### D) Agendamento Assistido

**MVP**:
- Campos no prospect:
  - `preferred_slots` (texto) - Janelas preferidas
  - `scheduled_at` (datetime) - Data/hora agendada
  - `meeting_link` (url) - Link da reunião (Zoom, Meet, etc.)
- Botão "Marcar Entrevista" (abre modal)
- Ao salvar:
  - Cria episódio em "Pauta"
  - Vincula convidado/tema
  - Cria tasks padrão automaticamente

**Evolução**:
- Integração com Calendly/Google Calendar
- Sincronização bidirecional
- Notificações automáticas

**Benefícios**:
- Reduz fricção de agendamento
- Cria estrutura do episódio automaticamente
- Integração com workflow existente

### E) Linha do Tempo (Log) por Prospect

**Funcionalidade**:
- Timeline simples e visual
- Eventos registrados automaticamente:
  - Criado (origem)
  - Aprovado
  - Convite enviado
  - Respondeu
  - Agendado
  - Confirmado
  - Gravado
  - Publicado
  - Follow-up

**Benefícios**:
- Rastreabilidade completa
- Memória institucional
- Previsibilidade do pipeline
- Visão clara do histórico

## 📊 Entidades de Suporte

### Prospect Contact (`prospect_contacts`)

**Papel**: Log de contato com o prospect.

**Campos-chave**:
- `prospect_id` (FK → prospects)
- `channel` (email/whatsapp/linkedin/phone)
- `direction` (outbound/inbound)
- `message_subject` (opcional)
- `message_body` (opcional - pode guardar só referência)
- `sent_at` (timestamp)
- `status` (sent, replied, bounced)
- `created_by` (FK → users)

**Regras**:
- Cada tentativa de contato gera um registro
- Permite rastrear histórico completo de comunicações
- Status ajuda a identificar prospects que não respondem

### Prospect Intake Token (`prospect_intake_tokens`)

**Papel**: Links únicos para ficha do convidado.

**Campos-chave**:
- `prospect_id` (FK → prospects)
- `token` (string único)
- `expires_at` (timestamp)
- `completed_at` (timestamp, nullable)
- `created_by` (FK → users)

**Regras**:
- Token único gerado quando prospect aceita
- Expira após X dias (configurável)
- `completed_at` preenchido quando prospect submete formulário
- Um prospect pode ter múltiplos tokens (se necessário)

### Guest Intake Submission (`guest_intake_submissions`)

**Papel**: Respostas do formulário de ficha do convidado.

**Campos-chave**:
- `prospect_id` (FK → prospects, nullable)
- `guest_id` (FK → guests, nullable)
- `bio` (texto)
- `official_links` (JSON)
- `photo_url` (string)
- `favorite_themes` (JSON)
- `availability` (texto)
- `image_voice_consent` (boolean)
- `submitted_at` (timestamp)

**Regras**:
- Pode estar vinculado a prospect OU guest
- Dados são usados para preencher Guest quando convertido
- Permite atualização posterior

---

**Responsável por**: Pipeline de curadoria e relacionamento editorial
