# Domínio Editorial

## 📋 Responsabilidades

O domínio **Editorial** é o núcleo do sistema. Gerencia todo o conteúdo editorial do podcast, desde a concepção até a publicação.

## 🎯 Entidades Principais

### Episódio (`episodes`)
**Papel**: Entidade central do pipeline editorial.

**Características**:
- Representa uma unidade de produção e publicação
- Possui ciclo de vida com status editorial
- Relaciona-se com praticamente todas as outras entidades

**Campos-chave**:
- `title`, `slug` (único)
- `status` (pauta → gravação → edição → revisão → agendado → publicado)
- `record_date`, `publish_date`
- `description`, `tags`
- `youtube_url`, `spotify_url`
- `created_by` (FK → users)

**Regras de Negócio**:
- Slug deve ser único no sistema
- Status segue uma máquina de estados (não pode voltar para status anterior)
- Data de publicação não pode ser anterior à data de gravação
- Episódio pode existir sem convidados (episódio solo)

### Convidado (`guests`)
**Papel**: Ativo de relacionamento e curadoria de rede.

**Características**:
- Reutilizável em múltiplos episódios
- Carrega histórico de participações
- Pode estar vinculado a uma organização
- Pode ter origem em um Prospect (curadoria)

**Campos-chave**:
- `name`
- `role_title` (cargo/atuação)
- `organization` (texto livre)
- `organization_id` (FK → organizations, opcional)
- `bio_short`
- `linkedin_url`, `website_url`
- `prospect_id` (FK → prospects, opcional) - Origem na curadoria

**Regras de Negócio**:
- Nome não precisa ser único (pode haver homônimos)
- Pode participar de múltiplos episódios
- Organização pode ser texto livre ou entidade estruturada
- Pode ter sido convertido de um Prospect (curadoria)

### Tema (`themes`)
**Papel**: Ativo estratégico de conteúdo.

**Características**:
- Representa assuntos abordados no podcast
- Permite análise de recorrência temática
- Ajuda na curadoria editorial

**Campos-chave**:
- `name` (único recomendado)
- `description` (opcional)

**Regras de Negócio**:
- Nome deve ser único para evitar duplicidades
- Um episódio pode ter múltiplos temas
- Um tema pode aparecer em múltiplos episódios

### Relação Episódio ↔ Convidado (`episode_guests`)
**Tipo**: Entidade associativa (N:N)

**Campos-chave**:
- `episode_id` (FK → episodes)
- `guest_id` (FK → guests)
- `guest_role` (host/cohost/convidado, opcional)

**Regras de Negócio**:
- PK composta evita duplicação do mesmo convidado no mesmo episódio
- Um episódio pode ter 0..N convidados
- Um convidado pode participar de 0..N episódios

### Relação Episódio ↔ Tema (`episode_themes`)
**Tipo**: Entidade associativa (N:N)

**Campos-chave**:
- `episode_id` (FK → episodes)
- `theme_id` (FK → themes)

**Regras de Negócio**:
- PK composta evita duplicação do mesmo tema no mesmo episódio
- Um episódio pode ter 0..N temas
- Um tema pode aparecer em 0..N episódios

## 🔄 Relacionamentos

```
Episódio (1) ──→ (N) Usuário (criador)
Episódio (N) ←──→ (N) Convidado (via episode_guests)
Episódio (N) ←──→ (N) Tema (via episode_themes)
Convidado (N) ──→ (1) Organização (opcional)
```

## 📐 Regras de Negócio Críticas

1. **Máquina de Estados do Episódio**:
   - Status segue fluxo: `pauta → gravação → edição → revisão → agendado → publicado`
   - Não é permitido voltar para status anterior (regra pode ser flexibilizada no futuro)
   - Apenas admins podem alterar status manualmente

2. **Slug de Episódio**:
   - Deve ser único no sistema
   - Gerado automaticamente a partir do título se não fornecido
   - Usado para URLs amigáveis

3. **Datas**:
   - `publish_date` não pode ser anterior a `record_date`
   - Ambas são opcionais durante a criação

4. **Convidados**:
   - Episódio pode existir sem convidados
   - Convidado pode ter papel definido (host, co-host, convidado)

5. **Temas**:
   - Episódio deve ter pelo menos um tema (regra pode ser flexibilizada)
   - Temas são reutilizáveis e acumulam histórico

## 🔗 Integrações com Outros Domínios

- **Operacional**: Episódio possui tarefas e assets
- **Governança**: Episódio é criado por um usuário
- **Inteligência**: Episódio possui métricas de performance
- **Calendário**: Episódio aparece no calendário baseado em datas
- **Relacionamento**: Convidados podem estar vinculados a organizações
- **Curadoria**: Convidados podem ter origem em Prospects (pipeline de curadoria)

## 🚀 Evoluções Futuras

- [ ] Histórico de mudanças de status do episódio
- [ ] Versões de descrição/roteiro do episódio
- [ ] Tags normalizadas (em vez de string simples)
- [ ] Sugestão automática de temas baseada em histórico
- [ ] Sugestão de convidados baseada em temas escolhidos (via Curadoria)
- [ ] Alertas de recorrência temática ("esse tema já apareceu muito")
- [ ] Integração com Curadoria para sugerir prospects baseado em temas do episódio

## 📊 Métricas e Insights Editoriais

O domínio editorial gera dados para:
- Temas mais recorrentes
- Convidados mais frequentes
- Tempo médio por etapa editorial
- Diversidade temática ao longo do tempo
- Evolução do conteúdo do podcast

---

**Responsável por**: Conteúdo e curadoria editorial do podcast
