# Domínio de Governança

## 📋 Responsabilidades

O domínio de **Governança** controla o acesso ao sistema, define permissões e garante rastreabilidade das ações dos usuários.

## 🎯 Entidades Principais

### Usuário (`users`)
**Papel**: Controle de acesso e autenticação.

**Características**:
- Autenticação via Laravel Breeze (sessões)
- Perfis de acesso (admin/editor)
- Rastreabilidade de ações

**Campos-chave**:
- `name`
- `email` (único)
- `password` (hash gerenciado pelo Laravel)
- `role` (admin/editor)
- `created_at`, `updated_at`

**Regras de Negócio**:
- Email deve ser único no sistema
- Senha é armazenada como hash (bcrypt)
- Role define permissões no sistema
- Usuário não pode ser deletado se tiver episódios criados (soft delete ou SET NULL)

**Perfis de Acesso**:

#### Admin
- Acesso total ao sistema
- Pode criar, editar e deletar qualquer conteúdo
- Pode gerenciar usuários
- Pode alterar status de episódios manualmente
- Acesso a relatórios e métricas

#### Editor
- Pode criar e editar conteúdo editorial
- Pode criar e editar episódios, convidados, temas
- Pode gerenciar tarefas e assets dos episódios
- Não pode deletar conteúdo (ou apenas próprio)
- Não pode gerenciar usuários
- Acesso limitado a relatórios

## 🔄 Relacionamentos

```
Usuário (1) ──→ (N) Episódio (criador)
Usuário (1) ──→ (N) Tarefa Editorial (responsável)
Usuário (1) ──→ (N) Nota Editorial (criador)
```

## 📐 Regras de Negócio Críticas

1. **Autenticação**:
   - Sistema usa Laravel Breeze com autenticação por sessão
   - Todas as rotas (exceto login) requerem autenticação
   - Sessão expira após inatividade (configurável)

2. **Autorização**:
   - Middleware verifica role do usuário
   - Policies controlam acesso a recursos específicos
   - Admin tem acesso irrestrito

3. **Rastreabilidade**:
   - Episódios registram `created_by`
   - Tarefas podem ter `assigned_to`
   - Notas registram `created_by`
   - No futuro: logs de auditoria para mudanças importantes

4. **Deleção de Usuário**:
   - Se usuário for deletado, `created_by` em episódios vira NULL (SET NULL)
   - Tarefas atribuídas podem virar NULL (SET NULL)
   - Histórico de ações é preservado

5. **Permissões por Recurso**:
   - **Episódios**: Editor pode criar/editar, Admin pode deletar
   - **Convidados**: Editor pode criar/editar, Admin pode deletar
   - **Temas**: Editor pode criar/editar, Admin pode deletar
   - **Usuários**: Apenas Admin pode gerenciar
   - **Relatórios**: Admin tem acesso total, Editor tem acesso limitado

## 🔗 Integrações com Outros Domínios

- **Editorial**: Usuários criam episódios
- **Operacional**: Usuários são responsáveis por tarefas
- **Inteligência**: Usuários podem acessar relatórios (com restrições)

## 🚀 Evoluções Futuras

- [ ] Logs de auditoria (quem mudou o quê, quando)
- [ ] Histórico de mudanças de status (rastreabilidade)
- [ ] Soft delete para usuários
- [ ] Permissões granulares (em vez de apenas admin/editor)
- [ ] Integração com OAuth (Google, GitHub, etc.)
- [ ] Dois fatores de autenticação (2FA)
- [ ] Sessões simultâneas (controle de dispositivos)
- [ ] Políticas de senha (complexidade, expiração)

## 📊 Métricas de Governança

O domínio de governança pode gerar dados para:
- Atividade por usuário
- Mudanças de status por usuário
- Distribuição de tarefas por usuário
- Logs de acesso e ações

## 🔐 Segurança

- Senhas são armazenadas como hash (bcrypt)
- Autenticação via sessão (Laravel Breeze)
- Middleware de autenticação em todas as rotas protegidas
- Policies para autorização granular
- Proteção CSRF em formulários
- Validação de entrada em todos os endpoints

---

**Responsável por**: Controle de acesso e segurança do sistema
