# Domínio de Inteligência

## 📋 Responsabilidades

O domínio de **Inteligência** fornece insights, análises e métricas editoriais para apoiar decisões estratégicas e operacionais.

## 🎯 Entidades Principais

### Métrica Editorial (`episode_metrics`)
**Papel**: Dados de performance e inteligência editorial.

**Características**:
- Métricas por episódio
- Permite histórico temporal
- Dados de performance editorial

**Campos-chave**:
- `episode_id` (FK → episodes)
- `views` (visualizações)
- `plays` (reproduções)
- `engagement_rate` (taxa de engajamento em %)
- `avg_time_to_publish_days` (tempo médio até publicação em dias)
- `metric_date` (data da métrica para histórico)
- `created_at`, `updated_at`

**Regras de Negócio**:
- Cada métrica pertence a um único episódio
- Um episódio pode ter 0..N métricas (histórico temporal)
- Métricas podem ser atualizadas ao longo do tempo
- `metric_date` permite rastrear evolução temporal

## 📊 Tipos de Insights

### 1. Insights Operacionais (Curto Prazo)

**Gargalos do Pipeline**:
- Em qual status os episódios ficam mais tempo?
- Onde o fluxo costuma travar: edição? revisão? agendamento?
- Quantos episódios estão "parados" sem tarefas ativas?

**Previsibilidade de Publicação**:
- Quantos episódios estão agendados para os próximos 7/14/30 dias?
- Há semanas sem publicação prevista?
- Alertas de "buraco editorial"

**Carga Operacional**:
- Quantas tarefas abertas por episódio?
- Quantas tarefas vencidas?
- Quem está com mais tarefas atribuídas?

### 2. Insights Editoriais (Curadoria e Conteúdo)

**Temas Recorrentes**:
- Quais temas aparecem com mais frequência?
- Existe excesso de repetição?
- Existem temas estratégicos pouco explorados?

**Evolução Temática no Tempo**:
- Quais temas dominaram cada trimestre?
- Há mudança de foco editorial ao longo do tempo?
- Análise de tendências temáticas

**Perfil dos Convidados**:
- Convidados recorrentes vs. novos
- Áreas mais representadas
- Organizações mais presentes

### 3. Insights de Ritmo e Cadência

**Ritmo Editorial Real**:
- Média de episódios publicados por mês
- Variação mês a mês
- Períodos de pico e de queda

**Tempo Médio por Etapa**:
- Gravação → publicação
- Edição → revisão
- Revisão → agendamento
- Identificação de gargalos operacionais

### 4. Insights de Relacionamento e Ecossistema

**Mapa de Conexões**:
- Quem são os convidados mais conectados?
- Quem retorna?
- Quem gera desdobramentos?

**Pós-Episódio**:
- Episódios que geraram follow-ups
- Convites que viraram novos projetos ou parcerias
- Impacto relacional do conteúdo

### 5. Insights de Qualidade Editorial

**Sinais Internos de Qualidade**:
- Episódios com mais notas editoriais
- Episódios com mais revisões
- Episódios com mais tarefas extras criadas

**Complexidade vs. Esforço**:
- Episódios simples vs. complexos
- Temas que exigem mais produção
- Convidados que demandam mais preparação

### 6. Insights de Governança

**Fluxo de Decisões**:
- Quem muda status com mais frequência?
- Onde ocorrem correções de rota?

**Memória Institucional**:
- Por que certos temas foram pausados?
- Por que certos formatos foram abandonados?

## 🔄 Relacionamentos

```
Episódio (1) ──→ (N) Métrica Editorial
```

## 📐 Regras de Negócio Críticas

1. **Métricas**:
   - Métricas são opcionais (episódio pode não ter métricas)
   - Métricas podem ser atualizadas ao longo do tempo
   - Histórico temporal permite análise de tendências

2. **Cálculos e Agregações**:
   - Insights são calculados em tempo real (não armazenados)
   - Relatórios podem ser gerados sob demanda
   - Performance: usar cache quando necessário

3. **Acesso a Relatórios**:
   - Admin tem acesso total a todos os relatórios
   - Editor tem acesso limitado (apenas relatórios operacionais)

## 🔗 Integrações com Outros Domínios

- **Editorial**: Métricas pertencem a episódios
- **Operacional**: Análise de tarefas e produtividade
- **Governança**: Controle de acesso a relatórios
- **Calendário**: Análise de ritmo e cadência

## 🚀 Evoluções Futuras

- [ ] Dashboard interativo com gráficos
- [ ] Relatórios exportáveis (PDF, Excel)
- [ ] Alertas automáticos (ex: "nenhum episódio agendado para próxima semana")
- [ ] Sugestões inteligentes (ex: "esse tema já apareceu muito")
- [ ] Integração com APIs externas (YouTube Analytics, Spotify Analytics)
- [ ] Análise de sentimento em comentários
- [ ] Previsão de engajamento baseada em histórico
- [ ] Relatórios comparativos (mês a mês, trimestre a trimestre)
- [ ] Export de dados para BI externo

## 📊 Relatórios Principais

1. **Relatório de Pipeline**: Status atual de todos os episódios
2. **Relatório Temático**: Análise de temas ao longo do tempo
3. **Relatório de Convidados**: Histórico e recorrência de convidados
4. **Relatório de Produtividade**: Tempo médio por etapa, tarefas concluídas
5. **Relatório de Ritmo Editorial**: Episódios publicados por período
6. **Relatório de Métricas**: Performance de episódios publicados

## 💡 Meta-Insights

O sistema deve responder perguntas como:
- "O que estamos dizendo como podcast?"
- "O que estamos deixando de dizer?"
- "Como estamos ocupando o tempo do nosso público?"
- "Qual é o papel editorial do podcast no ecossistema?"

---

**Responsável por**: Análises, métricas e insights editoriais
