# Mapa de Domínios — Visão Geral

## 🗺️ Visão Arquitetural

```
┌─────────────────────────────────────────────────────────────┐
│                    GESTOR EDITORIAL                         │
│                  Sistema de Podcast                          │
└─────────────────────────────────────────────────────────────┘
                              │
        ┌─────────────────────┼─────────────────────┐
        │                     │                     │
        ▼                     ▼                     ▼
┌───────────────┐    ┌───────────────┐    ┌───────────────┐
│  EDITORIAL    │    │  OPERACIONAL  │    │  GOVERNANÇA   │
│               │    │               │    │               │
│ • Episódios   │◄───┤ • Tarefas     │    │ • Usuários    │
│ • Convidados  │    │ • Assets      │    │ • Permissões  │
│ • Temas       │    │ • Checklist   │    │ • Auditoria   │
└───────┬───────┘    └───────┬───────┘    └───────┬───────┘
        │                    │                     │
        │                    │                     │
        └────────────────────┼─────────────────────┘
                             │
        ┌────────────────────┼─────────────────────┐
        │                    │                     │
        ▼                    ▼                     ▼
┌───────────────┐    ┌───────────────┐    ┌───────────────┐
│ INTELIGÊNCIA  │    │  CALENDÁRIO   │    │ RELACIONAMENTO│
│               │    │               │    │               │
│ • Métricas    │    │ • Agendamento │    │ • Organizações│
│ • Insights    │    │ • Ritmo       │    │ • Notas       │
│ • Relatórios  │    │ • Eventos     │    │ • Follow-ups  │
└───────────────┘    └───────────────┘    └───────────────┘
                             │
                             │
                    ┌────────┴────────┐
                    │                │
                    ▼                ▼
         ┌───────────────┐  ┌───────────────┐
         │  CURADORIA    │  │               │
         │               │  │               │
         │ • Prospects   │  │               │
         │ • Pipeline    │  │               │
         │ • Score       │  │               │
         └───────────────┘  └───────────────┘
```

## 🔗 Fluxo de Dependências

```
GOVERNANÇA (base)
    │
    ├──► EDITORIAL (criação de conteúdo)
    │       │
    │       ├──► OPERACIONAL (execução)
    │       │       │
    │       │       └──► CALENDÁRIO (planejamento temporal)
    │       │
    │       ├──► RELACIONAMENTO (rede e ecossistema)
    │       │
    │       └──► CURADORIA (pipeline de prospects)
    │               │
    │               └──► Converte em Guest (Editorial)
    │
    └──► INTELIGÊNCIA (análise e insights)
            │
            └──► Todos os outros domínios (consome dados)
```

## 📊 Matriz de Relacionamentos

| Domínio | Relaciona-se com | Tipo de Relação |
|---------|------------------|-----------------|
| **Editorial** | Operacional | Episódio possui tarefas e assets |
| **Editorial** | Governança | Episódio é criado por usuário |
| **Editorial** | Inteligência | Episódio possui métricas |
| **Editorial** | Calendário | Episódio aparece no calendário |
| **Editorial** | Relacionamento | Convidados vinculados a organizações |
| **Editorial** | Curadoria | Convidados podem ter origem em Prospects |
| **Operacional** | Governança | Tarefas atribuídas a usuários |
| **Operacional** | Calendário | Tarefas com prazo no calendário |
| **Inteligência** | Todos | Consome dados de todos os domínios |
| **Calendário** | Editorial | Visualiza episódios temporalmente |
| **Calendário** | Curadoria | Prospects agendados aparecem no calendário |
| **Relacionamento** | Governança | Notas criadas por usuários |
| **Relacionamento** | Curadoria | Prospects podem estar vinculados a organizações |
| **Curadoria** | Governança | Prospects criados por usuários |
| **Curadoria** | Editorial | Prospects relacionados a temas, convertem em Guests |

## 🎯 Responsabilidades por Domínio

### Núcleo (Core)
- **Editorial**: Conteúdo e curadoria
- **Operacional**: Execução e produção

### Suporte (Support)
- **Governança**: Acesso e segurança
- **Calendário**: Planejamento temporal
- **Relacionamento**: Rede e ecossistema
- **Curadoria**: Pipeline de relacionamento editorial

### Análise (Analytics)
- **Inteligência**: Insights e métricas

## 📈 Prioridade de Implementação

### Fase 1: MVP (Concluído)
- ✅ Editorial (Episódios, Convidados, Temas)
- ✅ Operacional (Tarefas, Assets)
- ✅ Governança (Usuários, Autenticação)

### Fase 2: Expansão (Em andamento)
- ✅ Calendário (Visualização temporal)
- ✅ Relacionamento (Organizações, Notas)
- 🔄 Inteligência (Métricas básicas)
- 🆕 Curadoria (Pipeline de prospects) - **NOVO**

### Fase 3: Evolução (Futuro)
- 🔮 Inteligência avançada (Insights, Relatórios)
- 🔮 Calendário avançado (Eventos, Integrações)
- 🔮 Relacionamento avançado (Follow-ups, Conexões)

## 🔄 Fluxo de Dados Principal

```
1. USUÁRIO (Governança) cadastra PROSPECT (Curadoria)
   │
   ├──► Prospect passa por PIPELINE (to_review → approved → confirmed)
   │
   └──► Prospect CONFIRMADO vira GUEST (Editorial)
       │
       └──► USUÁRIO cria EPISÓDIO com GUEST (Editorial)
           │
           ├──► Define TEMAS (Editorial)
           │
           ├──► Cria TAREFAS e ASSETS (Operacional)
           │
           ├──► Agenda no CALENDÁRIO (Calendário)
           │
           ├──► Registra NOTAS (Relacionamento)
           │
           └──► Gera MÉTRICAS (Inteligência)
```

## 📚 Documentação por Domínio

- [Editorial](editorial.md) - Conteúdo e curadoria
- [Operacional](operacional.md) - Execução e produção
- [Governança](governanca.md) - Acesso e segurança
- [Inteligência](inteligencia.md) - Insights e métricas
- [Calendário](calendario.md) - Planejamento temporal
- [Relacionamento](relacionamento.md) - Rede e ecossistema
- [Curadoria](curadoria.md) - Pipeline de curadoria e relacionamento editorial

---

**Última atualização**: Janeiro 2026
