# Domínio Operacional

## 📋 Responsabilidades

O domínio **Operacional** gerencia o fluxo de execução e produção dos episódios. Garante que o conteúdo editorial saia do papel e seja publicado com qualidade.

## 🎯 Entidades Principais

### Tarefa Editorial (`episode_tasks`)
**Papel**: Checklist operacional para garantir execução.

**Características**:
- Tarefas específicas por episódio
- Permite rastreamento de progresso
- Pode ter responsável e prazo

**Campos-chave**:
- `episode_id` (FK → episodes)
- `title` (título da tarefa)
- `is_done` (0/1)
- `due_date` (opcional)
- `assigned_to` (FK → users, opcional)

**Regras de Negócio**:
- Cada tarefa pertence a um único episódio
- Um episódio pode ter 0..N tarefas
- Tarefa pode ser atribuída a um usuário (opcional)
- Tarefa pode ter prazo (opcional)

**Exemplos de Tarefas**:
- Roteiro
- Confirmação do convidado
- Gravação
- Edição
- Cortes
- Thumb
- Publicação
- Divulgação

### Asset (`episode_assets`)
**Papel**: Central de materiais e links de produção por episódio.

**Características**:
- Armazena links para materiais externos
- Não armazena arquivos (estratégia: linkar, não armazenar)
- Organiza materiais por tipo

**Campos-chave**:
- `episode_id` (FK → episodes)
- `asset_type` (audio/video/thumb/roteiro/cortes/drive/outros)
- `label` (opcional, descrição do asset)
- `url` (link para o material)

**Regras de Negócio**:
- Cada asset pertence a um único episódio
- Um episódio pode ter 0..N assets
- URL é obrigatória
- Tipo de asset é obrigatório

**Tipos de Assets**:
- `audio`: Arquivo de áudio final
- `video`: Arquivo de vídeo final
- `thumb`: Thumbnail do episódio
- `roteiro`: Roteiro ou pauta
- `cortes`: Versões editadas ou cortes específicos
- `drive`: Link para pasta no Google Drive ou similar
- `outros`: Outros materiais relacionados

## 🔄 Relacionamentos

```
Episódio (1) ──→ (N) Tarefa Editorial
Episódio (1) ──→ (N) Asset
Tarefa Editorial (N) ──→ (1) Usuário (responsável, opcional)
```

## 📐 Regras de Negócio Críticas

1. **Tarefas Editoriais**:
   - Tarefas são específicas por episódio
   - Não há template de tarefas (pode ser evolução futura)
   - Tarefa pode ser marcada como concluída independentemente do status do episódio

2. **Assets**:
   - Estratégia: **armazenar links, não arquivos**
   - Assets podem ser adicionados em qualquer momento do ciclo de vida do episódio
   - Múltiplos assets do mesmo tipo são permitidos

3. **Workflow de Status**:
   - Status do episódio não depende diretamente das tarefas
   - Tarefas servem como checklist, não como bloqueio automático
   - No futuro: pode haver validação de tarefas críticas antes de mudar status

4. **Responsabilidades**:
   - Tarefa pode ser atribuída a um usuário
   - Usuário pode ter múltiplas tarefas atribuídas
   - Tarefa sem responsável é considerada "não atribuída"

## 🔗 Integrações com Outros Domínios

- **Editorial**: Tarefas e assets pertencem a episódios
- **Governança**: Tarefas podem ser atribuídas a usuários
- **Calendário**: Tarefas com prazo aparecem no calendário
- **Inteligência**: Tarefas geram métricas de produtividade

## 🚀 Evoluções Futuras

- [ ] Templates de checklist por tipo de episódio
- [ ] Validação de tarefas críticas antes de mudar status
- [ ] Sugestão automática de prazos baseada em histórico
- [ ] Score de prontidão editorial (baseado em tarefas concluídas)
- [ ] Alertas de tarefas vencidas
- [ ] Checklist adaptável ao tipo de episódio (entrevista, mesa redonda, solo)
- [ ] Integração com ferramentas externas (Google Drive API, etc.)
- [ ] Upload de arquivos (se necessário no futuro)

## 📊 Métricas Operacionais

O domínio operacional gera dados para:
- Tempo médio por etapa (gravação → publicação)
- Taxa de conclusão de tarefas
- Tarefas vencidas por período
- Carga operacional por usuário
- Gargalos no pipeline de produção

## 💡 Insights Operacionais

- **Gargalos do pipeline**: Onde os episódios ficam mais tempo?
- **Previsibilidade**: Quantos episódios estão agendados para os próximos dias?
- **Carga operacional**: Quantas tarefas abertas por episódio?
- **Produtividade**: Tempo médio de cada etapa do processo

---

**Responsável por**: Execução e produção dos episódios
