# Domínio de Relacionamento

## 📋 Responsabilidades

O domínio de **Relacionamento** gerencia a rede e o ecossistema do podcast, conectando convidados, organizações e desdobramentos pós-episódio.

## 🎯 Entidades Principais

### Organização (`organizations`)
**Papel**: Contexto institucional para vincular convidados a organizações.

**Características**:
- Representa empresas, startups, hubs, governos, ONGs, etc.
- Permite análise de relacionamento institucional
- Conecta convidados a organizações estruturadas

**Campos-chave**:
- `name`
- `type` (startup/hub/empresa/governo/ong/etc)
- `description` (opcional)
- `website_url`, `linkedin_url` (opcional)

**Regras de Negócio**:
- Uma organização pode ter 0..N convidados vinculados
- Convidado pode ter organização como texto livre OU entidade estruturada
- Organização pode existir sem convidados vinculados

### Nota Editorial (`episode_notes`)
**Papel**: Comentários internos e observações sobre episódios.

**Características**:
- Notas não públicas
- Permite colaboração e registro de decisões editoriais
- Histórico de observações sobre episódios

**Campos-chave**:
- `episode_id` (FK → episodes)
- `note` (texto do comentário)
- `created_by` (FK → users, opcional)
- `created_at`, `updated_at`

**Regras de Negócio**:
- Cada nota pertence a um único episódio
- Um episódio pode ter 0..N notas
- Nota pode ser criada por um usuário (opcional)
- Notas são internas (não públicas)

## 🔄 Relacionamentos

```
Organização (1) ──→ (N) Convidado
Episódio (1) ──→ (N) Nota Editorial
Nota Editorial (N) ──→ (1) Usuário (criador)
```

## 📐 Regras de Negócio Críticas

1. **Organizações**:
   - Organização pode existir sem convidados
   - Convidado pode ter organização como texto livre (campo `organization`) OU entidade estruturada (`organization_id`)
   - Permite flexibilidade no MVP e evolução futura

2. **Notas Editoriais**:
   - Notas são internas e não públicas
   - Permitem colaboração entre editores
   - Registram decisões e observações importantes
   - Podem ser usadas para memória institucional

3. **Follow-ups e Desdobramentos**:
   - Atualmente não há entidade específica (pode ser evolução futura)
   - Pode ser registrado em notas editoriais
   - Permite rastreamento de impacto relacional

## 🔗 Integrações com Outros Domínios

- **Editorial**: Organizações vinculam-se a convidados, notas pertencem a episódios
- **Governança**: Notas são criadas por usuários
- **Inteligência**: Análise de relacionamentos e conexões
- **Curadoria**: Prospects podem estar vinculados a organizações, pipeline de relacionamento

## 🚀 Evoluções Futuras

- [ ] Entidade `follow_ups` para rastrear desdobramentos pós-episódio
- [ ] Mapa de conexões (quem conhece quem)
- [ ] Sugestão de novos convidados baseada em rede (via Curadoria)
- [ ] Histórico de relacionamento com convidados
- [ ] Alertas de follow-up pendente
- [ ] Análise de impacto relacional (quais episódios geraram mais conexões)
- [ ] Integração com LinkedIn API (futuro)
- [ ] Tags de relacionamento (ex: "parceiro estratégico", "retorno", etc.)
- [ ] Integração com pipeline de Curadoria para follow-ups

## 📊 Métricas de Relacionamento

- Convidados recorrentes
- Organizações mais representadas
- Episódios que geraram follow-ups
- Conexões geradas pelo podcast
- Diversidade de organizações representadas

## 💡 Insights de Relacionamento

- **Mapa de Conexões**: Quem são os convidados mais conectados?
- **Retorno**: Quais convidados retornam ao podcast?
- **Desdobramentos**: Quais episódios geraram novos projetos ou parcerias?
- **Diversidade**: Estamos representando diferentes tipos de organizações?
- **Rede**: Como o podcast está fortalecendo o ecossistema?

## 🌐 Visão de Ecossistema

O domínio de relacionamento conecta o podcast ao ecossistema maior:
- Representação de diferentes tipos de organizações
- Conexões entre pessoas e instituições
- Impacto relacional do conteúdo
- Fortalecimento da rede de inovação

---

**Responsável por**: Gestão de rede e ecossistema do podcast
