Requisitos — Design System Visual (Tailwind + Flowbite)
1) Objetivo

Implementar um design system pronto para acelerar o desenvolvimento do MVP, garantindo:

consistência visual

componentes reutilizáveis

baixo custo de manutenção

boa UX em desktop (prioridade) e mobile (responsivo)

2) Stack e Dependências
Requisitos técnicos

Laravel 12 + Blade

Vite habilitado no projeto

Tailwind CSS instalado e compilando via Vite

Alpine.js disponível (para interações simples)

Flowbite instalado e integrado ao Tailwind

Requisitos de build

npm install funcionando

npm run dev e npm run build sem erros

assets carregando corretamente em produção

3) Padrões de UI (Design Tokens)
Tipografia e espaçamento

Usar padrões do Tailwind (sem CSS custom desnecessário)

Espaçamento mínimo: p-4 em containers, gap-3 em stacks

Cores

Usar paleta Flowbite/Tailwind padrão no MVP

Status dos episódios seguem semântica:

pauta: neutro

gravacao: informativo

edicao: warning

revisao: warning forte

agendado: info/sucesso leve

publicado: sucesso

Implementação via BadgeStatus (com mapeamento central).

4) Componentes obrigatórios (MVP)
Layout

Sidebar (Flowbite)

links: Dashboard, Episódios, Calendário, Convidados, Temas, Relatórios

item ativo destacado

Topbar (Flowbite)

nome do sistema

menu do usuário (dropdown)

Breadcrumbs (Flowbite)

Componentes de base

Button (variantes: primary, secondary, danger, ghost)

Badge / BadgeStatus

Card

Table

Modal de confirmação

Dropdown

Toast (ou alerts)

Formulários

Input text

Textarea

Select

Multi-select (MVP: <select multiple> estilizado; evolução: select pesquisável)

Date input

Componentes de domínio

EpisodeCard (para lista em cards ou tabela)

EpisodeFilters (status / tema / convidado)

TaskChecklist (toggle)

AssetList (add/delete)

StatusTransitionMenu (dropdown + confirmação)

5) Padrões de Interação (UX)
Feedback ao usuário

Ações de salvar/criar: toast “salvo com sucesso”

Erros de validação (422): mensagem por campo

Erros de permissão (403): toast

Sessão expirada (401/419): redirecionar login

Responsividade

Sidebar colapsável em mobile (Flowbite)

Tabelas com scroll horizontal em telas pequenas

Cards responsivos no Dashboard

Acessibilidade mínima

foco visível em inputs e botões

labels sempre presentes

modais com trap de foco (Flowbite)

6) Requisitos por Tela (UI pronto)
Dashboard

cards por status (contagem)

alertas (semana vazia, episódios parados)

lista de últimos episódios

CTA “Novo Episódio”

Lista de Episódios

filtros (status, tema, convidado)

listagem (tabela ou cards)

badge de status

ação “Abrir”

Episódio — Detalhe

header com título + BadgeStatus

botões: Editar / Avançar status

blocos: Convidados, Temas, Checklist, Assets

Criar/Editar Episódio

formulário com validação visual

multi-select convidados/temas

Calendário

navegação por mês

grid mensal

eventos com ícone e cor por tipo

Convidados / Temas

CRUD simples com tabela

busca por texto

7) Critérios de Aceite (DoD)
Integração técnica

Flowbite componentes renderizam corretamente

Tailwind build ok (dev e prod)

Alpine/Flowbite JS funcionando (dropdown, modal, sidebar mobile)

Consistência visual

BadgeStatus usado em todas as telas relevantes

botões e inputs padronizados

layout consistente (sidebar + header + breadcrumbs)

Performance mínima

CSS e JS carregam sem duplicação

páginas principais carregam sem “layout shift” perceptível