Perfeito — então vou vestir o boné do **time de frontend** e te entregar um **kickoff de execução**: arquitetura de UI, componentes, rotas/telas, contratos de integração com a API e um plano de sprints pra começar a codar sem tropeçar.

Vou me basear na sua documentação de API (Laravel 12 + Breeze session + JSON, endpoints de episódios, convidados, temas, tasks, assets, calendário e relatórios). 

---

## 1) Decisão de arquitetura de frontend (pra começar certo)

### Opção recomendada (MVP rápido e sólido)

**Laravel Blade + Tailwind + Alpine.js + HTMX (opcional)**

* Por quê: você já tem **Breeze session-based**, então o frontend pode ser “servidor-first”, com incrementos dinâmicos só onde precisa (toggle task, add asset, filtros, etc.). 
* Resultado: entrega rápida, pouco boilerplate, sem SPA pesada.

> Se mais pra frente quiser “produto SaaS com UX premium”, dá pra evoluir pra Inertia/Vue/React. Mas agora: **ganhar tração**.

---

## 2) Mapa de páginas (frontend backlog “zero confusão”)

### Navegação principal

* **Dashboard** (`/`)
* **Episódios** (`/episodes`)
* **Calendário** (`/calendar`)
* **Convidados** (`/guests`)
* **Temas** (`/themes`)
* **Relatórios** (`/reports`) (pode ficar no dashboard no MVP)

### Páginas essenciais (Sprint 1.1 / 2)

1. **Lista de Episódios**

   * filtros: status, tema, convidado
   * busca por título/slug (opcional)
2. **Detalhe do Episódio**

   * resumo + ações (editar, avançar status)
   * convidados e temas (chips)
   * checklist (toggle)
   * assets (add/delete)
3. **Criar/Editar Episódio**

   * multi-select convidados e temas
4. **Calendário**

   * visão mês/semana + filtros por tipo e status
5. CRUD simples de **Convidados** e **Temas**

Tudo isso conversa diretamente com os endpoints que você listou. 

---

## 3) Design system mínimo (para UI consistente desde o dia 1)

### Componentes base (reutilizáveis)

* `AppLayout` (sidebar/topbar + breadcrumbs)
* `BadgeStatus` (status do episódio)
* `Button` (primary/secondary/danger)
* `Input`, `Textarea`, `Select`, `MultiSelect`
* `Card`, `EmptyState`
* `Toast` (sucesso/erro)
* `ModalConfirm` (delete, avançar status)

### Padrão de status (mapeamento fixo no frontend)

Status possíveis: `pauta`, `gravacao`, `edicao`, `revisao`, `agendado`, `publicado`. 
O frontend precisa de:

* label amigável (ex: “Gravação”)
* cor/badge
* ordem do pipeline (para timeline/kanban futuro)

---

## 4) Contrato de integração com API (sem dor)

### Autenticação e CSRF

Como é **session-based** (Breeze), o frontend precisa:

* garantir que todas as requests mutáveis enviem **CSRF token** (`X-CSRF-TOKEN`). 
* lidar com 401/403 redirecionando pra login.

### Estratégia de chamadas (MVP)

* `fetch()` + helper `apiFetch()`
* tratamento padrão de erros 422 (validação) exibindo mensagens por campo (API já manda `errors`). 

---

## 5) UX “que dá gosto de usar” (pequenos diferenciais baratos)

### Episódio: ações rápidas

* Botão **“Avançar status”**

  * antes de chamar: buscar `allowed-transitions`
  * se vazio: mostrar aviso “Sem transições disponíveis”
  * se houver: exibir menu com opções e confirmar
  * se voltar 422: mostrar lista de bloqueios (API devolve). 

### Checklist: toggle sem reload

* PATCH `/episodes/{episode_id}/tasks/{task_id}` com `is_done`
* Atualiza UI imediatamente (optimistic UI leve), e se falhar, desfaz com toast. 

### Assets: add e delete rápido

* form inline
* lista abaixo com ações
* validação de URL (frontend) + backend (deixa o backend ser o juiz final)

---

## 6) Calendário no frontend (muito importante)

A API já entrega eventos agrupados por dia (`events["YYYY-MM-DD"] = [ ... ]`). 
No frontend, a implementação mais eficiente no MVP é:

* **View Month**

  * render grid do mês
  * em cada dia, listar até 2 eventos + “+N”
* **View Week** (depois)
* filtros:

  * `event_types[]` (recording/publication/task)
  * `statuses[]`

> Bônus de UX: clique no evento abre **drawer/modal** com link pro episódio.

---

## 7) Plano de trabalho do “time de frontend” (prático)

### Sprint FE-1 (base e consistência)

* Layout + navegação + breadcrumbs
* BadgeStatus + UI kit mínimo
* helper `apiFetch()` com CSRF + handling 422

### Sprint FE-2 (Episódios end-to-end)

* Lista de episódios com filtros (`status`, `theme_id`, `guest_id`) 
* Create/Edit episódio com multi-select convidados/temas
* Show episódio com chips convidados/temas

### Sprint FE-3 (Operação: checklist + assets)

* Checklist toggle (PATCH)
* Assets add/delete
* Avançar status + allowed transitions + erros 422 bem exibidos 

### Sprint FE-4 (Calendário + relatórios)

* Calendário month consumindo `/calendar`
* Relatórios:

  * top themes
  * average publish time 

---