Perfeito. Vou desenhar o **fluxo de interação** como um time de frontend faria: jornadas principais, estados de tela, ações, feedback e erros. Isso vira base direta pra implementação (Blade + Flowbite + Alpine).

---

# Fluxo de Interação — Podcast Editorial Manager

## 0) Papéis e premissas

**Papéis (MVP):**

* **Admin**: tudo
* **Editor**: operação editorial (sem gestão de usuários)

**Princípio UX:**
*“O usuário deve conseguir fazer o trabalho sem navegar demais.”*
Tela de episódio é a **central de comando**.

---

## 1) Jornada A — Entrar no sistema (Login)

### A1 — Acessar URL protegida

* Usuário acessa `/episodes`
* Se não logado → redireciona para `/login`

**UI**

* Form login
* Mensagens claras

**Erros**

* Credenciais inválidas → mensagem no form
* Sessão expirada → toast “Sessão expirada, faça login novamente”

**Sucesso**

* Redirect para `intended` (ou Dashboard)

---

## 2) Jornada B — Criar um episódio (da pauta ao registro)

### B1 — Dashboard → “Novo Episódio”

**Ação:** clicar em `+ Novo Episódio`
**Vai para:** `/episodes/create`

### B2 — Preencher formulário

Campos mínimos:

* Título (obrigatório)
* Status default: `pauta`
* Datas (opcionais)
* Convidados (opcional)
* Temas (opcional)

**Ação:** clicar `Salvar`

**Feedback**

* Botão entra em `loading`
* Em sucesso → toast “Episódio criado” + redirect para `/episodes/{id}`

**Erros (422)**

* Campo obrigatório faltando → mensagem abaixo do campo
* Datas inválidas → mensagem abaixo do campo

---

## 3) Jornada C — Operar o episódio (checklist + assets + status)

> Essa é a jornada “diária”. Precisa ser rápida e sem atrito.

### C1 — Abrir episódio

**De:** lista ou calendário
**Para:** `/episodes/{id}`

**A tela exibe**

* Header: título + `BadgeStatus`
* Bloco “Convidados” (chips)
* Bloco “Temas” (chips)
* Bloco “Checklist”
* Bloco “Assets”
* Ações no topo:

  * `Editar`
  * `Avançar status ▾`

---

### C2 — Marcar tarefa como concluída (toggle)

**Ação:** clicar no checkbox da tarefa
**Request:** `PATCH /api/episodes/{episode_id}/tasks/{task_id}`

**Comportamento (UX recomendado)**

* **Optimistic UI**: muda visual na hora
* Se sucesso: mantém + opcional “salvo”
* Se erro: reverte e mostra toast “Não foi possível atualizar”

**Erros**

* 401/419: redirect login
* 403: toast sem permissão

---

### C3 — Adicionar asset (link)

**Ação:** no bloco Assets, preencher:

* tipo
* label (opcional)
* url
  e clicar `Adicionar`

**Request:** `POST /api/episodes/{id}/assets`

**Feedback**

* item aparece na lista em seguida
* form limpa
* toast “Asset adicionado”

**Erros (422)**

* URL inválida → mensagem no campo
* tipo vazio → mensagem no campo

---

### C4 — Remover asset

**Ação:** clicar em `Excluir` → abre `ModalConfirm`

**Request:** `DELETE /api/episodes/{episode_id}/assets/{asset_id}`

**Feedback**

* remove item da lista
* toast “Asset removido”

---

### C5 — Avançar status (máquina de estados)

**Ação:** clicar em `Avançar status ▾`

**Step 1: carregar transições**

* frontend chama `GET /api/episodes/{id}/allowed-transitions`
* dropdown lista opções (ex: `revisao`, `agendado`)

**Step 2: escolher destino**

* clicar numa opção abre confirmação:

  * “Mudar status para Revisão?”

**Step 3: confirmar**

* `POST /api/episodes/{id}/transition` com `{ to: "revisao" }`

**Sucesso**

* atualiza badge de status
* toast “Status atualizado”
* (opcional) animação leve no badge

**Bloqueio de regra (422)**

* exibir bloco de mensagens:

  * “Não é possível publicar sem links”
  * “Tarefas obrigatórias pendentes”
* incluir link/âncora para o bloco relevante (assets ou checklist)

---

## 4) Jornada D — Planejar pelo calendário (ritmo editorial)

### D1 — Abrir calendário mensal

**URL:** `/calendar?month=YYYY-MM`

**UI**

* header com navegação mês: `◀` / `▶`
* filtros:

  * tipo de evento (gravação/publicação/tarefa)
  * status (opcional)

**Interação**

* clique em evento abre:

  * modal/drawer com:

    * label do evento
    * status do episódio
    * link “Abrir episódio”

**Erro**

* se API falhar: mostrar EmptyState “Não foi possível carregar o calendário”

---

## 5) Jornada E — Gerenciar convidados (cadastro rápido)

### E1 — Lista de convidados

**URL:** `/guests`

* busca por nome/organização
* CTA `+ Novo Convidado`

### E2 — Criar convidado

Campos:

* nome (obrigatório)
* cargo/atuação
* organização
* bio curta
* links

**Sucesso**

* toast
* redirect para lista (ou detalhe)

**Uso direto**

* convidado passa a aparecer no MultiSelect do episódio

---

## 6) Jornada F — Gerenciar temas (curadoria)

### F1 — Lista de temas

**URL:** `/themes`

* busca por nome
* CTA `+ Novo Tema`

### F2 — Criar tema

Campos:

* nome (obrigatório)
* descrição (opcional)

**Sucesso**

* toast
* tema passa a aparecer no MultiSelect do episódio

---

## 7) Jornada G — Leitura de relatórios (insights leves)

### G1 — Abrir relatórios

**URL:** `/reports` (ou cards no dashboard)

**Cards**

* Temas mais recorrentes
* Tempo médio gravação → publicação

**Interação**

* clicar em “ver detalhes” → lista filtrada (ex: episodes por tema)

---

# Estados de Interface (padrão para todas as telas)

## Loading

* skeleton simples (cards/tabela)
* desabilitar botões de submit

## Empty

* EmptyState com CTA
* texto específico: “Nenhum episódio encontrado”

## Error

* banner/alert no topo da página
* ação: “Tentar novamente”

---

# Microinterações (que dão cara de produto)

* Badge de status atualiza sem reload
* Checklist toggle instantâneo
* Modal confirm para deletes e transições
* Toast de sucesso/erro consistente

---