# Episode Status Map — Padrões de UI e Fluxo

Este documento padroniza labels, ordem do pipeline e estilo visual do status do episódio.

## 1) Status suportados
Valores (backend):
- `pauta`
- `gravacao`
- `edicao`
- `revisao`
- `agendado`
- `publicado`

## 2) Ordem do pipeline
1. pauta
2. gravacao
3. edicao
4. revisao
5. agendado
6. publicado

## 3) Labels amigáveis (UI)
- pauta -> "Pauta"
- gravacao -> "Gravação"
- edicao -> "Edição"
- revisao -> "Revisão"
- agendado -> "Agendado"
- publicado -> "Publicado"

## 4) Badges (guideline)
Sem fixar cores obrigatórias aqui (para manter tema flexível),
mas manter a semântica:
- pauta: neutro
- gravacao: informativo
- edicao: warning/andamento
- revisao: warning/atenção
- agendado: info/sucesso leve
- publicado: sucesso

`BadgeStatus` deve usar este mapeamento.

## 5) Regras de exibição
- Sempre mostrar `BadgeStatus` em:
  - EpisodeCard (lista)
  - EpisodeShow (título)
  - Calendar events (mini-badge se for evento de episódio)
- Em filtros:
  - usar os labels amigáveis
  - manter a ordem do pipeline

## 6) Integração com máquina de estados
O frontend não decide transições.
Ele consome:
- `GET /api/episodes/{id}/allowed-transitions`
E aciona:
- `POST /api/episodes/{id}/transition`

Se a API retornar 422 (bloqueio), exibir mensagens de forma clara e acionável.
