# Frontend Routes — Podcast Editorial Manager

Este documento define rotas de UI, parâmetros, e o que cada tela precisa carregar.

## 1) Rotas principais

### 1.1 Dashboard
- **GET** `/`
- Objetivo: visão geral (status counts + últimos episódios + atalhos)
- Data:
  - `GET /api/dashboard` (se existir) ou compor via:
    - `GET /api/episodes?per_page=10&sort=updated_at_desc`
    - `GET /api/reports/status-counts` (opcional)

---

### 1.2 Episódios
#### Lista
- **GET** `/episodes`
- Filtros (querystring):
  - `status`
  - `theme_id`
  - `guest_id`
  - `q` (busca por título/slug, opcional)
- API:
  - `GET /api/episodes?status=&theme_id=&guest_id=&q=`

#### Criar
- **GET** `/episodes/create`
- API para selects:
  - `GET /api/guests?per_page=200` (ou endpoint de options)
  - `GET /api/themes?per_page=200`

- **POST** `/episodes`
- Payload:
  - `title`, `slug?`
  - `record_date?`, `publish_date?`
  - `status` (default pauta)
  - `description?`, `tags?`
  - `guest_ids[]`
  - `theme_ids[]`

#### Detalhe
- **GET** `/episodes/{id}`
- API:
  - `GET /api/episodes/{id}` (incluir guests, themes, tasks, assets)

Ações dentro do detalhe:
- Toggle task:
  - `PATCH /api/episodes/{episode_id}/tasks/{task_id}`
- Assets:
  - `POST /api/episodes/{episode_id}/assets`
  - `DELETE /api/episodes/{episode_id}/assets/{asset_id}`
- Transições de status:
  - `GET /api/episodes/{id}/allowed-transitions`
  - `POST /api/episodes/{id}/transition`

#### Editar
- **GET** `/episodes/{id}/edit`
- **PUT/PATCH** `/episodes/{id}`
- Recarregar options de guests/themes como no create.

---

### 1.3 Calendário
- **GET** `/calendar`
- Query:
  - `month=YYYY-MM` (default mês atual)
  - `event_types[]=recording|publication|task` (opcional)
  - `statuses[]=...` (opcional)
- API:
  - `GET /api/calendar?month=YYYY-MM&event_types[]=...&statuses[]=...`

UI:
- View mensal (grid)
- Clique no evento -> abrir Episode detail (ou drawer modal)

---

### 1.4 Convidados
#### Lista
- **GET** `/guests`
- Query:
  - `q` (nome/organização)
- API:
  - `GET /api/guests?q=`

#### Criar / Editar
- **GET** `/guests/create`
- **POST** `/guests`
- **GET** `/guests/{id}/edit`
- **PUT/PATCH** `/guests/{id}`
- Campos:
  - name, role_title?, organization?, bio_short?
  - linkedin_url?, website_url?

#### Detalhe (opcional no MVP)
- **GET** `/guests/{id}`
- Mostra:
  - perfil + episódios relacionados
- API:
  - `GET /api/guests/{id}` (com episodes)

---

### 1.5 Temas
#### Lista
- **GET** `/themes`
- API:
  - `GET /api/themes?q=`

#### Criar / Editar
- **GET** `/themes/create`
- **POST** `/themes`
- **GET** `/themes/{id}/edit`
- **PUT/PATCH** `/themes/{id}`
- Campos:
  - name, description?

---

### 1.6 Relatórios (pode ser subpágina do dashboard)
- **GET** `/reports`
- Cards:
  - Temas mais recorrentes
  - Tempo médio gravação -> publicação
- API:
  - `GET /api/reports/top-themes`
  - `GET /api/reports/avg-publish-time`

---

## 2) Rotas de sessão (Breeze)
- `/login`, `/logout`, `/register` (se habilitado)
- Páginas protegidas por `auth`

---

## 3) Padrões de UX por rota
- Todas as telas de lista:
  - EmptyState com CTA “Criar”
  - Loading state
- Todas as telas de form:
  - mapear erros 422 por campo
  - toast de sucesso
- Detalhe do episódio:
  - ações rápidas no topo (editar, avançar status)
