# 📦 Instalador do Gestor Editorial

Bem-vindo ao instalador do Gestor Editorial! Este diretório contém todos os arquivos necessários para instalação do projeto após o upload via filemanager.

## 📁 Arquivos Disponíveis

### Scripts Principais

| Arquivo | Descrição | Quando Usar |
|---------|-----------|-------------|
| `instalar.php` | **Script principal de instalação** | Execute após configurar o .env |
| `verificar-requisitos.php` | Verifica pré-requisitos do sistema | Execute antes da instalação |
| `criar-env-example.php` | Cria o arquivo .env.example | Se o .env.example não existir |
| `instalar.ps1` | Script PowerShell (Windows local) | Para desenvolvimento local no Windows |

### Documentação

| Arquivo | Descrição |
|---------|-----------|
| `README.md` | **Documentação completa** com todos os detalhes |
| `INSTRUCOES-RAPIDAS.md` | Guia rápido de 5 minutos |
| `INDEX.md` | Este arquivo - índice dos arquivos |

### Segurança

| Arquivo | Descrição |
|---------|-----------|
| `.htaccess` | Proteção da pasta instalador (descomente após instalação) |

## 🚀 Fluxo de Instalação Recomendado

```
0. Criar ZIP otimizado (criar-zip-producao.ps1 ou .php)
   ↓
1. Upload do projeto (ZIP otimizado) → Extrair
   ↓
2. php instalador/verificar-requisitos.php
   ↓
3. Configurar .env (copiar .env.example para .env e editar)
   ↓
4. php instalador/instalar.php
   ↓
5. Configurar servidor web (DocumentRoot → backend/public)
   ↓
6. Configurar permissões (storage, bootstrap/cache)
   ↓
7. Proteger pasta instalador (.htaccess)
   ↓
8. ✅ Pronto!
```

## 📖 Documentação Detalhada

- **Para instruções completas:** Leia `README.md`
- **Para instalação rápida:** Leia `INSTRUCOES-RAPIDAS.md`
- **Para criar ZIP otimizado:** Leia `README-ZIP.md` ⭐ **IMPORTANTE!**

## ⚠️ Importante

1. **Sempre execute** `verificar-requisitos.php` antes de `instalar.php`
2. **Configure o .env** antes de executar a instalação
3. **Proteja a pasta instalador** após a instalação (descomente o `.htaccess`)
4. **Altere as senhas padrão** após o primeiro acesso

## 🔒 Segurança Pós-Instalação

Após concluir a instalação:

1. ✅ Remova ou proteja `instalar.php`
2. ✅ Configure `APP_DEBUG=false` no `.env`
3. ✅ Configure HTTPS/SSL
4. ✅ Altere todas as senhas padrão
5. ✅ Descomente as regras no `.htaccess`

## 📞 Precisa de Ajuda?

Consulte a seção "Solução de Problemas" no `README.md` ou verifique os logs:
- Laravel: `backend/storage/logs/laravel.log`
- Servidor web: logs do Apache/Nginx

---

**Versão:** 1.0  
**Última atualização:** Janeiro 2026
