# Instruções Rápidas de Instalação

## 🚀 Instalação Rápida (5 minutos)

### 1. Upload e Extração
- Zip o projeto completo
- Faça upload no filemanager
- Extraia o ZIP

### 2. Configurar .env
```bash
# Se .env.example não existir:
php instalador/criar-env-example.php

# Copiar .env.example para .env
cp backend/.env.example backend/.env

# Editar .env (via filemanager ou editor)
# Configure: APP_URL, DB_HOST, DB_DATABASE, DB_USERNAME, DB_PASSWORD
```

### 3. Executar Instalação
```bash
php instalador/instalar.php
```

### 4. Configurar Servidor Web
- Apache: DocumentRoot → `backend/public`
- Nginx: root → `backend/public`
- Habilitar mod_rewrite (Apache)

### 5. Permissões
```bash
chmod -R 775 backend/storage backend/bootstrap/cache
```

## ✅ Pronto!

Acesse: `https://seudominio.com`

**Login padrão:**
- Admin: `admin@empatheia.me` / `admin123`
- Editor: `editor@gestor-editorial.com` / `editor123`

⚠️ **ALTERE AS SENHAS PADRÃO IMEDIATAMENTE!**

## 🔒 Segurança Pós-Instalação

1. Remova ou proteja: `instalador/instalar.php`
2. Configure: `APP_DEBUG=false` no `.env`
3. Configure HTTPS/SSL
4. Altere todas as senhas padrão

---

Para instruções detalhadas, consulte: `README.md`
