# 📦 Criando ZIP para Produção

O projeto completo pode ter mais de 3GB devido a dependências e arquivos de desenvolvimento. **NÃO é necessário zipar tudo!**

## 🎯 Solução: ZIP Otimizado

Criamos scripts que geram um ZIP otimizado excluindo:
- ✅ `vendor/` - será reinstalado via `composer install`
- ✅ `node_modules/` - será reinstalado via `npm install` (se necessário)
- ✅ `docker/` - não é necessário em produção
- ✅ `tests/` - testes não são necessários em produção
- ✅ `.git/` - controle de versão
- ✅ Logs e cache do `storage/`
- ✅ Arquivos de desenvolvimento

**Resultado:** O ZIP terá aproximadamente **50-200MB** em vez de 3GB!

## 🚀 Como Usar

### Opção 1: PowerShell (Windows)

```powershell
cd instalador
.\criar-zip-producao.ps1
```

O arquivo `gestor-editorial-producao.zip` será criado na raiz do projeto.

### Opção 2: PHP (Windows/Linux/Mac)

```bash
cd instalador
php criar-zip-producao.php
```

Ou com nome personalizado:

```bash
php criar-zip-producao.php meu-projeto.zip
```

## 📋 O que será incluído no ZIP

✅ **backend/** (código da aplicação)
- ✅ `app/` - Controllers, Models, Services, etc.
- ✅ `config/` - Configurações
- ✅ `database/` - Migrations e Seeders
- ✅ `public/` - Arquivos públicos
- ✅ `resources/` - Views e assets
- ✅ `routes/` - Rotas
- ✅ `storage/` - Estrutura (sem logs/cache)
- ✅ `composer.json` e `composer.lock`
- ✅ `artisan` - CLI do Laravel

✅ **instalador/** - Scripts de instalação

✅ **docs/** - Documentação (opcional, mas útil)

✅ **readme.md** - Documentação principal

## ❌ O que será excluído

❌ `backend/vendor/` - Dependências PHP (reinstaladas via composer)
❌ `backend/node_modules/` - Dependências JS (reinstaladas via npm)
❌ `docker/` - Configuração Docker
❌ `backend/tests/` - Testes
❌ `.git/` - Controle de versão
❌ `backend/.env` - Arquivo de ambiente (não deve ser enviado!)
❌ `backend/storage/logs/*.log` - Logs
❌ `backend/storage/framework/cache/*` - Cache
❌ Arquivos de desenvolvimento (.idea, .vscode, etc.)

## 📊 Tamanho Esperado

- **Antes:** ~3GB (com vendor, node_modules, etc.)
- **Depois:** ~50-200MB (apenas código e estrutura)

## 🔄 Processo Completo

1. **Criar ZIP otimizado:**
   ```powershell
   cd instalador
   .\criar-zip-producao.ps1
   ```

2. **Upload no filemanager:**
   - Faça upload do arquivo `gestor-editorial-producao.zip`
   - Extraia no diretório desejado

3. **Instalar dependências:**
   - O script `instalar.php` executará automaticamente:
     - `composer install` (reinstala vendor/)
     - `npm install` (se necessário)
     - Migrações e seeders

4. **Configurar:**
   - Configure o `.env`
   - Execute `php instalador/instalar.php`

## ⚠️ Importante

- **NUNCA** envie o arquivo `.env` no ZIP (contém senhas e configurações sensíveis)
- O script de instalação criará o `.env` a partir do `.env.example`
- Certifique-se de que o servidor tem `composer` instalado
- O processo de instalação reinstalará todas as dependências

## 🐛 Solução de Problemas

### Erro: "Extensão ZIP não habilitada" (PHP)

**Windows:**
- Edite `php.ini`
- Descomente: `extension=zip`
- Reinicie o servidor web

**Linux:**
```bash
sudo apt-get install php-zip
sudo service php-fpm restart
```

### ZIP ainda muito grande

Verifique se:
- `vendor/` foi excluído corretamente
- `node_modules/` foi excluído
- Logs grandes não foram incluídos

### Script não funciona

Use a alternativa:
- PowerShell: `criar-zip-producao.ps1`
- PHP: `criar-zip-producao.php`

---

**Dica:** Execute o script sempre antes de fazer deploy para garantir um ZIP otimizado!
