# Instalador do Gestor Editorial

Este diretório contém os arquivos necessários para instalação do projeto após o upload via filemanager.

## 📋 Pré-requisitos

Antes de executar a instalação, certifique-se de que:

1. **PHP 8.2 ou superior** está instalado
2. **Composer** está instalado e disponível no PATH
3. **Banco de dados MySQL/MariaDB** está configurado e acessível
4. **Extensões PHP necessárias** estão instaladas:
   - pdo
   - pdo_mysql
   - mbstring
   - openssl
   - tokenizer
   - xml
   - ctype
   - json
   - fileinfo

## 🚀 Processo de Instalação

### Passo 0: Criar ZIP Otimizado (IMPORTANTE!)

**⚠️ NÃO zipar o projeto completo (3GB+)** - Use o script para criar um ZIP otimizado (~50-200MB):

**Windows (PowerShell):**
```powershell
cd instalador
.\criar-zip-producao.ps1
```

**Linux/Mac/Windows (PHP):**
```bash
cd instalador
php criar-zip-producao.php
```

O script exclui automaticamente:
- `vendor/` (será reinstalado via composer)
- `node_modules/` (será reinstalado via npm)
- `docker/`, `tests/`, `.git/`, logs, cache, etc.

**Resultado:** ZIP de ~50-200MB em vez de 3GB+!

📖 **Documentação completa:** Veja `README-ZIP.md`

### Passo 1: Upload do Projeto

1. Use o ZIP otimizado criado pelo script acima
2. Faça upload do arquivo ZIP no filemanager do seu servidor
3. Extraia o arquivo ZIP no diretório desejado

### Passo 2: Configurar o Arquivo .env

1. Acesse o diretório `backend` via filemanager ou SSH
2. Se o arquivo `.env.example` não existir, execute:
   ```bash
   php instalador/criar-env-example.php
   ```
3. Copie o arquivo `.env.example` para `.env`:
   ```bash
   cp backend/.env.example backend/.env
   ```
   Ou via filemanager: copie `.env.example` e renomeie para `.env`
4. Edite o arquivo `.env` e configure as seguintes variáveis:

```env
# Aplicação
APP_NAME="Gestor Editorial"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://seudominio.com

# Banco de Dados
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=nome_do_banco
DB_USERNAME=usuario_banco
DB_PASSWORD=senha_banco
```

**Importante:**
- `APP_URL` deve ser a URL completa do seu site (com https://)
- `DB_HOST` geralmente é `127.0.0.1` ou `localhost` em hospedagens compartilhadas
- `DB_DATABASE`, `DB_USERNAME` e `DB_PASSWORD` devem ser fornecidos pelo seu provedor de hospedagem

### Passo 3: Executar o Script de Instalação

#### Opção A: Via SSH (Recomendado)

```bash
cd /caminho/para/o/projeto
php instalador/instalar.php
```

#### Opção B: Via Filemanager (cPanel/hPanel)

1. Acesse o filemanager
2. Navegue até a pasta `instalador`
3. Clique com o botão direito no arquivo `instalar.php`
4. Selecione "Executar" ou "Run" (dependendo do painel)

#### Opção C: Via Navegador (não recomendado para produção)

Acesse: `https://seudominio.com/instalador/instalar.php`

**Nota:** Após a instalação, remova ou proteja o arquivo `instalar.php` por segurança.

### Passo 4: Configurar o Servidor Web

#### Apache

Certifique-se de que o `DocumentRoot` aponta para a pasta `public`:

```apache
<VirtualHost *:80>
    ServerName seudominio.com
    DocumentRoot /caminho/para/projeto/backend/public
    
    <Directory /caminho/para/projeto/backend/public>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

#### Nginx

```nginx
server {
    listen 80;
    server_name seudominio.com;
    root /caminho/para/projeto/backend/public;
    
    index index.php;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.2-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

### Passo 5: Configurar Permissões

Execute os seguintes comandos via SSH:

```bash
cd /caminho/para/projeto/backend
chmod -R 775 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

**Nota:** O usuário `www-data` pode variar dependendo do servidor. Verifique com seu provedor.

## ✅ Verificação Pós-Instalação

Após a instalação, verifique:

1. ✅ Acesse a aplicação no navegador
2. ✅ Faça login com as credenciais padrão:
   - **Admin:** `admin@empatheia.me` / `admin123`
   - **Editor:** `editor@gestor-editorial.com` / `editor123`
3. ✅ **IMPORTANTE:** Altere as senhas padrão imediatamente após o primeiro acesso
4. ✅ Verifique se as migrações foram executadas corretamente
5. ✅ Verifique se os seeders foram executados (temas, usuários)

## 🔧 Comandos Úteis

Se precisar executar comandos manualmente:

```bash
cd /caminho/para/projeto/backend

# Gerar chave da aplicação
php artisan key:generate

# Executar migrações
php artisan migrate --force

# Executar seeders
php artisan db:seed --force

# Limpar caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear

# Otimizar para produção
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## 🐛 Solução de Problemas

### Erro: "Composer não encontrado"

- Instale o Composer: https://getcomposer.org/download/
- Ou use o Composer via SSH do seu provedor de hospedagem

### Erro: "Falha ao executar migrações"

- Verifique as credenciais do banco de dados no arquivo `.env`
- Certifique-se de que o banco de dados existe
- Verifique se o usuário do banco tem permissões adequadas

### Erro: "Permissão negada" em storage

```bash
chmod -R 775 storage bootstrap/cache
```

### Erro 500 após instalação

1. Verifique os logs em `backend/storage/logs/laravel.log`
2. Verifique se o `APP_KEY` foi gerado corretamente
3. Limpe os caches: `php artisan config:clear && php artisan cache:clear`

### Página em branco

1. Ative o `APP_DEBUG=true` temporariamente no `.env` para ver erros
2. Verifique os logs do servidor
3. Verifique se todas as dependências foram instaladas

## 🔒 Segurança

Após a instalação:

1. ✅ Remova ou proteja o arquivo `instalador/instalar.php`
2. ✅ Certifique-se de que `APP_DEBUG=false` em produção
3. ✅ Altere todas as senhas padrão
4. ✅ Configure HTTPS (SSL/TLS)
5. ✅ Mantenha o Laravel e as dependências atualizadas

## 📞 Suporte

Em caso de problemas, verifique:
- Logs do Laravel: `backend/storage/logs/laravel.log`
- Logs do servidor web
- Documentação do Laravel: https://laravel.com/docs

---

**Versão:** 1.0  
**Última atualização:** Janeiro 2026
