<?php
/**
 * Script auxiliar para criar o arquivo .env.example no backend
 * Execute este script se o .env.example não existir
 */

$rootDir = dirname(__DIR__);
$backendDir = $rootDir . '/backend';
$envExampleFile = $backendDir . '/.env.example';

if (file_exists($envExampleFile)) {
    echo "Arquivo .env.example já existe em: $envExampleFile\n";
    exit(0);
}

$content = <<<'ENV'
APP_NAME="Gestor Editorial"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_TIMEZONE=UTC
APP_URL=http://localhost

APP_LOCALE=pt_BR
APP_FALLBACK_LOCALE=pt_BR
APP_FAKER_LOCALE=pt_BR

APP_MAINTENANCE_DRIVER=file
APP_MAINTENANCE_STORE=database

BCRYPT_ROUNDS=12

LOG_CHANNEL=stack
LOG_STACK=single
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=gestor_editorial
DB_USERNAME=root
DB_PASSWORD=

SESSION_DRIVER=database
SESSION_LIFETIME=120
SESSION_ENCRYPT=false
SESSION_PATH=/
SESSION_DOMAIN=null

BROADCAST_CONNECTION=log
FILESYSTEM_DISK=local
QUEUE_CONNECTION=database

CACHE_STORE=database
CACHE_PREFIX=

MEMCACHED_HOST=127.0.0.1

REDIS_CLIENT=phpredis
REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

MAIL_MAILER=log
MAIL_HOST=127.0.0.1
MAIL_PORT=2525
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS="hello@example.com"
MAIL_FROM_NAME="${APP_NAME}"

AWS_ACCESS_KEY_ID=
AWS_SECRET_ACCESS_KEY=
AWS_DEFAULT_REGION=us-east-1
AWS_BUCKET=
AWS_USE_PATH_STYLE_ENDPOINT=false

VITE_APP_NAME="${APP_NAME}"
ENV;

if (!is_dir($backendDir)) {
    echo "ERRO: Diretório 'backend' não encontrado!\n";
    exit(1);
}

if (file_put_contents($envExampleFile, $content)) {
    echo "✓ Arquivo .env.example criado com sucesso em: $envExampleFile\n";
} else {
    echo "ERRO: Não foi possível criar o arquivo .env.example\n";
    exit(1);
}
