# Podcast — Editorial Manager

Sistema simples em **PHP + MySQL** para gestão da editoração e da produção editorial de **Podcast**.

O objetivo é organizar, acompanhar e dar visibilidade a todo o fluxo de produção dos episódios — da pauta à publicação — de forma leve, prática e escalável.

---

## 🎯 Objetivo do Projeto

Centralizar a gestão editorial do podcast, permitindo:

- Gerenciamento estruturado de convidados  
- Curadoria e histórico dos temas abordados  
- Controle dos episódios por status de produção  
- Organização de checklists operacionais  
- Registro de assets e links de produção  
- Padronização de descrições e informações editoriais  
- Visão clara do pipeline de episódios  

Sem complexidade desnecessária. Sem ruído. Só execução.

---

## 🧩 Funcionalidades (MVP)

### Episódios

- Cadastro e edição de episódios  
- Acompanhamento por status de produção:
  - pauta  
  - gravação  
  - edição  
  - revisão  
  - agendado  
  - publicado  
- Registro de datas:
  - data de gravação  
  - data de publicação  
- Associação com convidados  
- Associação com temas abordados  
- Descrição editorial, tags e links  
- Links para YouTube, Spotify e outros canais  

### Checklist Editorial

- Criação de tarefas por episódio  
- Marcação de tarefas concluídas  
- Prazos e responsáveis (opcional)  

### Assets

- Registro de links para:
  - áudio  
  - vídeo  
  - roteiro  
  - thumb  
  - cortes  
  - Google Drive ou outros repositórios  

### Usuários

- Autenticação com Laravel Breeze (sessões)  
- Perfis de acesso:
  - Admin (acesso total)  
  - Editor (criação e edição de conteúdo)  

### Dashboard

- Visão geral dos episódios por status  
- Lista dos últimos episódios atualizados  

---

## 🛠️ Stack Técnica

- **Backend**: PHP (Laravel 12)  
- **Banco de Dados**: MySQL 8.0  
- **Frontend**: Blade Templates (Laravel) + HTML/CSS/JS  
- **Autenticação**: Laravel Breeze (sessões)  
- **Arquitetura**: MVC com Laravel (Controllers, Models, Views, Routes)  
- **Containerização**: Docker + Docker Compose  

---

## 📂 Estrutura de Pastas

Estrutura atual do projeto:

- `backend/` — aplicação Laravel completa (controllers, models, views Blade, rotas, migrations, etc.)  
- `docker/` — arquivos de configuração Docker, Dockerfiles, scripts e `docker-compose.yml`  
- `docs/` — documentação complementar do projeto (diagramas, anotações, referências, etc.)  
- `readme.md` — documentação principal do projeto  

Organização interna do `backend/` (padrão Laravel):

- `backend/public/` — ponto de entrada da aplicação (index.php, assets públicos)  
- `backend/app/` — código da aplicação
  - `app/Http/Controllers/` — controladores  
  - `app/Models/` — modelos Eloquent  
  - `app/Services/` — serviços de negócio  
  - `app/Policies/` — políticas de autorização  
  - `app/Observers/` — observadores de modelos  
- `backend/resources/views/` — templates Blade  
- `backend/routes/` — definição de rotas (web.php, api.php)  
- `backend/database/` — migrations, seeders, factories  
- `backend/config/` — arquivos de configuração  
- `backend/storage/` — logs, cache, arquivos de sessão  
- `backend/vendor/` — dependências Composer  

Essa estrutura pode ser ajustada conforme a evolução do projeto.

---

## 📚 Documentação

- **[Documentação da API Backend](docs/backend-api.md)** — Guia completo da API REST para o time de frontend
- **[Entidades do Banco de Dados](docs/entidades.md)** — Diagrama ER e definições das entidades
- **[Plano de Execução](docs/plano_execucao.md)** — Roadmap e status do projeto
- **[Calendário](docs/calendario.md)** — Especificação da funcionalidade de calendário

---

## 🗄️ Banco de Dados (visão geral)

Entidades principais esperadas:

- **Episódios**
  - título, descrição, status, datas (gravação/publicação), links externos, etc.  
- **Convidados**
  - nome, bio/resumo, contatos, redes sociais, etc.  
- **Temas**
  - nome, descrição/observações, tags, etc.  
- **Checklist / Tarefas**
  - tarefa, status (pendente/concluída), prazo, responsável, vínculo com episódio  
- **Assets**
  - tipo (áudio, vídeo, roteiro, thumb, cortes...), URL, vínculo com episódio  
- **Usuários**
  - nome, email/login, senha (hash), perfil (Admin/Editor)  

O esquema físico das tabelas pode ser documentado em um arquivo SQL próprio (`database/schema.sql`) à medida que for definido.

---

## 🚀 Como Rodar o Projeto Localmente (com Docker)

Pré-requisitos:

- **Docker** instalado  
- **Docker Compose** (ou `docker compose` integrado ao Docker Desktop)  

Passos básicos:

1. Clone este repositório:

   git clone https://seu-repositorio.git gestor_editorial
   cd gestor_editorial
   